/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Compiler {
    private Compiler() {
    }

    private static native void initialize();

    private static native void registerNatives();

    public static native boolean compileClass(Class<?> var0);

    public static native boolean compileClasses(String var0);

    public static native Object command(Object var0);

    public static native void enable();

    public static native void disable();

    static {
        Compiler.registerNatives();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                boolean loaded = false;
                String jit = System.getProperty("java.compiler");
                if (jit != null && !jit.equals("NONE") && !jit.equals("")) {
                    try {
                        System.loadLibrary(jit);
                        Compiler.initialize();
                        loaded = true;
                    }
                    catch (UnsatisfiedLinkError e) {
                        System.err.println("Warning: JIT compiler \"" + jit + "\" not found. Will use interpreter.");
                    }
                }
                String info = System.getProperty("java.vm.info");
                if (loaded) {
                    System.setProperty("java.vm.info", info + ", " + jit);
                } else {
                    System.setProperty("java.vm.info", info + ", nojit");
                }
                return null;
            }
        });
    }
}

