/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerTableHover {
    private static final boolean REPAINT_ON_HIDE = !Boolean.getBoolean("ProfilerTableHover.noRepaintOnHide");
    private final ProfilerTable table;
    private Popup popup;
    private Point popupLocation;
    private Rectangle popupRect;
    private AWT awt;
    private Mouse mouse;
    private Paranoid paranoid;
    private Point currentPoint;
    private Point forwardPoint;
    private static CellRendererPane PAINTER;

    static void install(ProfilerTable profilerTable) {
        new ProfilerTableHover(profilerTable).install();
    }

    private ProfilerTableHover(ProfilerTable profilerTable) {
        this.table = profilerTable;
    }

    private void install() {
        this.mouse = new Mouse();
        this.mouse.install();
    }

    private void showPopup(Painter painter, Rectangle rectangle) {
        this.mouse.deinstall();
        Point point = this.table.getLocationOnScreen();
        rectangle.translate(point.x, point.y);
        this.popupRect = rectangle;
        this.popupLocation = new Point(point.x + painter.getX(), point.y + painter.getY());
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this.table, painter, this.popupLocation.x, this.popupLocation.y);
        this.popup.show();
        this.paranoid = new Paranoid(painter);
        this.paranoid.install();
        this.awt = new AWT();
        this.awt.install();
    }

    private void hidePopup() {
        if (this.awt != null) {
            this.awt.deinstall();
            this.awt = null;
        }
        if (this.paranoid != null) {
            this.paranoid.deinstall();
            this.paranoid = null;
        }
        this.popup.hide();
        this.popupRect = null;
        this.popupLocation = null;
        this.popup = null;
        if (REPAINT_ON_HIDE) {
            this.table.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerTableHover.this.mouse.install();
            }
        });
    }

    private void checkPopup(int n, int n2, Point point) {
        if (n < 0 || n >= this.table.getRowCount()) {
            return;
        }
        if (n2 < 0 || n2 >= this.table.getColumnCount()) {
            return;
        }
        if (point == null) {
            point = this.currentPoint;
        } else {
            this.currentPoint = point;
        }
        if (point == null) {
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        Rectangle rectangle2 = this.getRendererRect(n, n2);
        if (rectangle2 == null) {
            return;
        }
        rectangle2.translate(rectangle.x, rectangle.y);
        if (rectangle.contains(rectangle2)) {
            return;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.contains(point)) {
            this.showPopup(new Painter(n, n2, rectangle2), rectangle3);
        }
    }

    private Rectangle getRendererRect(int n, int n2) {
        Component component = this.getRenderer(n, n2);
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("ProfilerTableHover_NoHover") != null) {
            return null;
        }
        Rectangle rectangle = component.getBounds();
        rectangle.x -= this.table.getColumnOffset(this.table.convertColumnIndexToModel(n2));
        return rectangle;
    }

    private Component getRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
        return this.table.getRenderer(tableCellRenderer, n, n2, true);
    }

    private static CellRendererPane getPainter() {
        if (PAINTER == null) {
            PAINTER = new CellRendererPane(){

                @Override
                public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
                    super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
                    this.remove(component);
                }
            };
        }
        return PAINTER;
    }

    private class Painter
    extends JPanel {
        private final int row;
        private final int column;
        private final Object value;
        private final TableCellRenderer renderer;

        Painter(int n, int n2, Rectangle rectangle) {
            super(null);
            this.row = n;
            this.column = n2;
            this.value = ProfilerTableHover.this.table.getValueAt(n, n2);
            this.renderer = ProfilerTableHover.this.table.getCellRenderer(n, n2);
            this.setBorder(BorderFactory.createLineBorder(ProfilerTableHover.this.table.getGridColor()));
            this.setBounds(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            this.setPreferredSize(this.getSize());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Component component = ProfilerTableHover.this.table.getRenderer(this.renderer, this.row, this.column, false);
            ProfilerTableHover.getPainter().paintComponent(graphics, component, null, 1, 1, this.getWidth() - 2, this.getHeight() - 2, false);
        }

        int getRow() {
            return this.row;
        }

        int getColumn() {
            return this.column;
        }

        boolean valueChanged() {
            if (ProfilerTableHover.this.table.getRowCount() <= this.row) {
                return true;
            }
            if (ProfilerTableHover.this.table.getColumnCount() <= this.column) {
                return true;
            }
            Object object = ProfilerTableHover.this.table.getValueAt(this.row, this.column);
            if (object == null && this.value == null) {
                return false;
            }
            if (object != null && this.value != null) {
                return !object.equals(this.value);
            }
            return true;
        }
    }

    private class Mouse
    extends MouseAdapter {
        private Mouse() {
        }

        void install() {
            ProfilerTableHover.this.table.addMouseMotionListener(this);
        }

        void deinstall() {
            ProfilerTableHover.this.table.removeMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() != 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            if (point.equals(ProfilerTableHover.this.forwardPoint)) {
                return;
            }
            ProfilerTableHover.this.checkPopup(ProfilerTableHover.this.table.rowAtPoint(point), ProfilerTableHover.this.table.columnAtPoint(point), point);
        }
    }

    private class Paranoid
    implements TableModelListener,
    KeyListener,
    ComponentListener,
    HierarchyListener,
    HierarchyBoundsListener,
    FocusListener,
    PropertyChangeListener {
        private final Painter painter;
        private Component focusOwner;

        Paranoid(Painter painter) {
            this.painter = painter;
        }

        void install() {
            this.focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.focusOwner != null) {
                this.focusOwner.addKeyListener(this);
                if (ProfilerTableHover.this.table.equals(this.focusOwner)) {
                    ProfilerTableHover.this.table.addFocusListener(this);
                }
            }
            ProfilerTableHover.this.table.getModel().addTableModelListener(this);
            ProfilerTableHover.this.table.addComponentListener(this);
            ProfilerTableHover.this.table.addHierarchyListener(this);
            ProfilerTableHover.this.table.addHierarchyBoundsListener(this);
        }

        void deinstall() {
            if (this.focusOwner != null) {
                this.focusOwner.removeKeyListener(this);
                if (ProfilerTableHover.this.table.equals(this.focusOwner)) {
                    ProfilerTableHover.this.table.removeFocusListener(this);
                }
                this.focusOwner = null;
            }
            ProfilerTableHover.this.table.getModel().removeTableModelListener(this);
            ProfilerTableHover.this.table.removeComponentListener(this);
            ProfilerTableHover.this.table.removeHierarchyListener(this);
            ProfilerTableHover.this.table.removeHierarchyBoundsListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (this.painter.valueChanged()) {
                final int n = this.painter.getRow();
                final int n2 = this.painter.getColumn();
                ProfilerTableHover.this.hidePopup();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTableHover.this.checkPopup(n, n2, null);
                    }
                });
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProfilerTableHover.this.hidePopup();
        }
    }

    private class AWT
    implements AWTEventListener {
        private AWT() {
        }

        void install() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 131072L);
        }

        void deinstall() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (ProfilerTableHover.this.popup == null) {
                return;
            }
            if (!(aWTEvent instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (this.isIgnoreEvent(mouseEvent)) {
                return;
            }
            if (mouseEvent.getID() == 503 && this.overPopup(mouseEvent)) {
                return;
            }
            if (!this.overPopup(mouseEvent)) {
                ProfilerTableHover.this.hidePopup();
            } else if (this.isForwardEvent(mouseEvent)) {
                Point point = ProfilerTableHover.this.popupLocation;
                ProfilerTableHover.this.hidePopup();
                this.forwardEvent(mouseEvent, point);
            }
        }

        private boolean overPopup(MouseEvent mouseEvent) {
            if (ProfilerTableHover.this.popupRect == null) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            return ProfilerTableHover.this.popupRect.contains(point);
        }

        private boolean isIgnoreEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            return n == 504 || n == 505;
        }

        private boolean isForwardEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            return n == 501 || n == 502 || n == 507;
        }

        private void forwardEvent(MouseEvent mouseEvent, Point point) {
            Point point2 = mouseEvent.getPoint();
            point2.translate(point.x, point.y);
            SwingUtilities.convertPointFromScreen(point2, ProfilerTableHover.this.table);
            ProfilerTableHover.this.forwardPoint = new Point(point2.x - 1, point2.y - 1);
            MouseWheelEvent mouseWheelEvent = mouseEvent instanceof MouseWheelEvent ? (MouseWheelEvent)mouseEvent : null;
            MouseEvent mouseEvent2 = mouseWheelEvent != null ? new MouseWheelEvent((Component)ProfilerTableHover.this.table, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()) : new MouseEvent(ProfilerTableHover.this.table, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            ProfilerTableHover.this.table.dispatchEvent(mouseEvent2);
            if (mouseEvent.getID() == 501) {
                mouseEvent2 = new MouseEvent(ProfilerTableHover.this.table, 502, mouseEvent.getWhen() + 1L, mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                ProfilerTableHover.this.table.dispatchEvent(mouseEvent2);
            }
        }
    }
}

