/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.IntegerFreeList;
import javax.media.j3d.MemoryFreeList;

class FreeListManager {
    private static final boolean DEBUG = false;
    static final int DISPLAYLIST = 0;
    static final int TEXTURE2D = 1;
    static final int TEXTURE3D = 2;
    private static int maxFreeListNum = 2;
    private static int currlist = 0;
    static MemoryFreeList[] freelist = null;

    FreeListManager() {
    }

    static void createFreeLists() {
        maxFreeListNum = 2;
        freelist = new MemoryFreeList[maxFreeListNum + 1];
        FreeListManager.freelist[0] = new IntegerFreeList();
        FreeListManager.freelist[1] = new IntegerFreeList();
        FreeListManager.freelist[2] = new IntegerFreeList();
    }

    static void manageLists() {
        if (freelist[currlist] != null) {
            freelist[currlist].shrink();
        }
        if (++currlist > maxFreeListNum) {
            currlist = 0;
        }
    }

    static MemoryFreeList getFreeList(int n) {
        if (n < 0 || n > maxFreeListNum) {
            return null;
        }
        return freelist[n];
    }

    static Object getObject(int n) {
        return freelist[n].getObject();
    }

    static void freeObject(int n, Object object) {
        freelist[n].add(object);
    }

    static void clearList(int n) {
        freelist[n].clear();
    }
}

