/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Sets;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.RunnableScriptFilter;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.AbstractPythonTestConfigurationProducer;
import com.jetbrains.python.testing.PyTestLegacyInteropKt;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonTestLegacyConfigurationProducer<T extends AbstractPythonLegacyTestRunConfiguration<T>>
extends AbstractPythonTestConfigurationProducer<AbstractPythonLegacyTestRunConfiguration<T>> {
    @Deprecated
    protected PythonTestLegacyConfigurationProducer(ConfigurationFactory configurationFactory) {
        super(configurationFactory);
        if (PyTestLegacyInteropKt.isNewTestsModeEnabled()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    protected PythonTestLegacyConfigurationProducer() {
    }

    @Override
    @NotNull
    public Class<? super AbstractPythonLegacyTestRunConfiguration<T>> getConfigurationClass() {
        if (AbstractPythonLegacyTestRunConfiguration.class == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(0);
        }
        return AbstractPythonLegacyTestRunConfiguration.class;
    }

    public boolean isConfigurationFromContext(@NotNull AbstractPythonLegacyTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        String path;
        boolean isTestFileEquals;
        VirtualFile virtualFile;
        Location location;
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null || !this.isAvailable(location)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        AbstractPythonLegacyTestRunConfiguration.TestType confType = configuration.getTestType();
        String workingDirectory = configuration.getWorkingDirectory();
        if (element instanceof PsiDirectory) {
            String path2 = ((PsiDirectory)element).getVirtualFile().getPath();
            return confType == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_FOLDER && path2.equals(configuration.getFolderName()) || path2.equals(new File(workingDirectory, configuration.getFolderName()).getAbsolutePath());
        }
        String scriptName = configuration.getScriptName();
        boolean bl = isTestFileEquals = scriptName.equals(path = virtualFile.getPath()) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
        if (pyFunction != null) {
            String methodName = configuration.getMethodName();
            if (pyFunction.getContainingClass() == null) {
                return confType == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_FUNCTION && methodName.equals(pyFunction.getName()) && isTestFileEquals;
            }
            String className = configuration.getClassName();
            return confType == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_METHOD && methodName.equals(pyFunction.getName()) && pyClass != null && className.equals(pyClass.getName()) && isTestFileEquals;
        }
        if (pyClass != null) {
            String className = configuration.getClassName();
            return confType == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_CLASS && className.equals(pyClass.getName()) && isTestFileEquals;
        }
        return confType == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT && isTestFileEquals;
    }

    protected boolean setupConfigurationFromContext(@NotNull AbstractPythonLegacyTestRunConfiguration<T> configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location;
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null || !this.isAvailable(location)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiWhiteSpace) {
            element = PyUtil.findNonWhitespaceAtOffset(element.getContainingFile(), element.getTextOffset());
        }
        if (RunnableScriptFilter.isIfNameMain(location)) {
            return false;
        }
        Module module2 = location.getModule();
        if (!PythonTestLegacyConfigurationProducer.isPythonModule(module2)) {
            return false;
        }
        if (element instanceof PsiDirectory) {
            return this.setupConfigurationFromFolder((PsiDirectory)element, configuration);
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        if (pyFunction != null && this.isTestFunction(pyFunction, configuration)) {
            return this.setupConfigurationFromFunction(pyFunction, configuration);
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (pyClass != null && this.isTestClass(pyClass, configuration, TypeEvalContext.userInitiated(pyClass.getProject(), element.getContainingFile()))) {
            return this.setupConfigurationFromClass(pyClass, configuration);
        }
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && this.isTestFile((PyFile)file)) {
            return this.setupConfigurationFromFile((PyFile)file, configuration);
        }
        return false;
    }

    private boolean setupConfigurationFromFolder(@NotNull PsiDirectory element, @NotNull AbstractPythonLegacyTestRunConfiguration configuration) {
        VirtualFile virtualFile;
        if (element == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (!this.isTestFolder(virtualFile = element.getVirtualFile(), element.getProject())) {
            return false;
        }
        String path = virtualFile.getPath();
        configuration.setTestType(AbstractPythonLegacyTestRunConfiguration.TestType.TEST_FOLDER);
        configuration.setFolderName(path);
        configuration.setWorkingDirectory(path);
        configuration.setGeneratedName();
        PythonTestLegacyConfigurationProducer.setModuleSdk((PsiElement)element, configuration);
        return true;
    }

    private static void setModuleSdk(@NotNull PsiElement element, @NotNull AbstractPythonLegacyTestRunConfiguration configuration) {
        if (element == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(9);
        }
        configuration.setUseModuleSdk(true);
        configuration.setModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    protected boolean setupConfigurationFromFunction(@NotNull PyFunction pyFunction, @NotNull AbstractPythonLegacyTestRunConfiguration configuration) {
        if (pyFunction == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(11);
        }
        PyClass containingClass = pyFunction.getContainingClass();
        configuration.setMethodName(pyFunction.getName());
        if (containingClass != null) {
            configuration.setClassName(containingClass.getName());
            configuration.setTestType(AbstractPythonLegacyTestRunConfiguration.TestType.TEST_METHOD);
        } else {
            configuration.setTestType(AbstractPythonLegacyTestRunConfiguration.TestType.TEST_FUNCTION);
        }
        return PythonTestLegacyConfigurationProducer.setupConfigurationScript(configuration, pyFunction);
    }

    protected boolean setupConfigurationFromClass(@NotNull PyClass pyClass, @NotNull AbstractPythonLegacyTestRunConfiguration configuration) {
        if (pyClass == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(13);
        }
        configuration.setTestType(AbstractPythonLegacyTestRunConfiguration.TestType.TEST_CLASS);
        configuration.setClassName(pyClass.getName());
        return PythonTestLegacyConfigurationProducer.setupConfigurationScript(configuration, pyClass);
    }

    protected boolean setupConfigurationFromFile(@NotNull PyFile pyFile, @NotNull AbstractPythonLegacyTestRunConfiguration configuration) {
        if (pyFile == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (configuration == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(15);
        }
        configuration.setTestType(AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT);
        return PythonTestLegacyConfigurationProducer.setupConfigurationScript(configuration, pyFile);
    }

    protected static boolean setupConfigurationScript(@NotNull AbstractPythonLegacyTestRunConfiguration cfg, @NotNull PyElement element) {
        PyFile containingFile;
        if (cfg == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(17);
        }
        if ((containingFile = PyUtil.getContainingPyFile(element)) == null) {
            return false;
        }
        VirtualFile vFile = containingFile.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent = vFile.getParent();
        if (parent == null) {
            return false;
        }
        cfg.setScriptName(vFile.getPath());
        if (StringUtil.isEmptyOrSpaces((String)cfg.getWorkingDirectory())) {
            cfg.setWorkingDirectory(parent.getPath());
        }
        cfg.setGeneratedName();
        PythonTestLegacyConfigurationProducer.setModuleSdk((PsiElement)element, cfg);
        return true;
    }

    protected boolean isTestFolder(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Module[] modules;
        if (virtualFile == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(18);
        }
        if (project == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(19);
        }
        String name = virtualFile.getName();
        HashSet roots = Sets.newHashSet();
        for (Module module2 : modules = ModuleManager.getInstance((Project)project).getModules()) {
            roots.addAll(PyUtil.getSourceRoots(module2));
        }
        Collections.addAll(roots, ProjectRootManager.getInstance((Project)project).getContentRoots());
        return StringUtil.toLowerCase((String)name).contains("test") || roots.contains(virtualFile);
    }

    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(20);
        }
        return false;
    }

    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonLegacyTestRunConfiguration configuration, @Nullable TypeEvalContext context) {
        if (pyClass == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(21);
        }
        return PythonUnitTestUtil.isTestClass(pyClass, ThreeState.UNSURE, context);
    }

    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonLegacyTestRunConfiguration configuration) {
        if (pyFunction == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(22);
        }
        return PythonUnitTestUtil.isTestFunction(pyFunction, ThreeState.UNSURE, null);
    }

    protected boolean isTestFile(@NotNull PyFile file) {
        List<PyStatement> testCases;
        if (file == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(23);
        }
        return !(testCases = this.getTestCaseClassesFromFile(file)).isEmpty();
    }

    protected static boolean isPythonModule(Module module2) {
        Facet[] allFacets;
        if (module2 == null) {
            return false;
        }
        if (ModuleType.get((Module)module2) instanceof PythonModuleTypeBase) {
            return true;
        }
        for (Facet facet : allFacets = FacetManager.getInstance((Module)module2).getAllFacets()) {
            if (!(facet.getConfiguration() instanceof PythonFacetSettings)) continue;
            return true;
        }
        return false;
    }

    protected List<PyStatement> getTestCaseClassesFromFile(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PythonTestLegacyConfigurationProducer.$$$reportNull$$$0(24);
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(pyFile.getProject(), pyFile);
        return pyFile.getTopLevelClasses().stream().filter(o -> PythonUnitTestUtil.isTestClass(o, ThreeState.UNSURE, context)).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PythonTestLegacyConfigurationProducer";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PythonTestLegacyConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setModuleSdk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromFunction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationScript";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTestFolder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTestFunction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTestFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestCaseClassesFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

