/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Sets;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.sdk.PySdkUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineBreakpointType
extends XLineBreakpointTypeBase {
    public static final String ID = "python-line";
    private static final String NAME = "Python Line Breakpoint";
    private static final Set<IElementType> UNSTOPPABLE_ELEMENT_TYPES = Sets.newHashSet((Object[])new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE, PyTokenTypes.DOCSTRING});
    private static final Class<? extends PsiElement>[] UNSTOPPABLE_ELEMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    public PyLineBreakpointType() {
        super(ID, NAME, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public PyLineBreakpointType(@NotNull String id, @NotNull String title, @Nullable XDebuggerEditorsProvider editorsProvider) {
        if (id == null) {
            PyLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            PyLineBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, title, editorsProvider);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line2, @NotNull Project project) {
        if (file == null) {
            PyLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(3);
        }
        Ref stoppable = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null && this.isSuitableFileType(project, file)) {
            this.lineHasStoppablePsi(project, file, line2, document, this.getUnstoppableElements(), this.getUnstoppableElementTypes(), (Ref<? super Boolean>)stoppable);
        }
        return (Boolean)stoppable.get();
    }

    protected boolean isSuitableFileType(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PyLineBreakpointType.$$$reportNull$$$0(5);
        }
        return file.getFileType() == this.getFileType() || ScratchUtil.isScratch((VirtualFile)file) && LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) == this.getFileLanguage();
    }

    protected FileType getFileType() {
        return PythonFileType.INSTANCE;
    }

    protected Language getFileLanguage() {
        return PythonLanguage.INSTANCE;
    }

    protected Set<IElementType> getUnstoppableElementTypes() {
        return UNSTOPPABLE_ELEMENT_TYPES;
    }

    protected Class<? extends PsiElement>[] getUnstoppableElements() {
        return UNSTOPPABLE_ELEMENTS;
    }

    protected boolean isPsiElementStoppable(PsiElement psiElement) {
        return psiElement.getLanguage() == PythonLanguage.INSTANCE;
    }

    protected void lineHasStoppablePsi(@NotNull Project project, @NotNull VirtualFile file, int line2, Document document, Class<? extends PsiElement>[] unstoppablePsiElements, Set<IElementType> unstoppableElementTypes, Ref<? super Boolean> stoppable) {
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PyLineBreakpointType.$$$reportNull$$$0(7);
        }
        if (!PyLineBreakpointType.isSkeleton(project, file)) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line2, psiElement -> {
                if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])unstoppablePsiElements) != null) {
                    return true;
                }
                if (psiElement.getNode() != null && unstoppableElementTypes.contains(psiElement.getNode().getElementType())) {
                    return true;
                }
                if (this.isPsiElementStoppable((PsiElement)psiElement)) {
                    stoppable.set((Object)true);
                }
                return false;
            });
            if (PyDebugSupportUtils.isContinuationLine(document, line2 - 1)) {
                stoppable.set((Object)false);
            }
        }
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.THREAD;
    }

    private static boolean isSkeleton(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PyLineBreakpointType.$$$reportNull$$$0(9);
        }
        if (PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(file)) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile != null && PySdkUtil.isElementInSkeletons((PsiElement)psiFile);
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyLineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableFileType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lineHasStoppablePsi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isSkeleton";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

