/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.VcsSynchronousProgressWrapper;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitRevisionNumber;
import git4idea.GitRevisionSelector;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitRepositoryForAnnotationsListener;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableValidator;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.status.GitChangeProvider;
import git4idea.ui.branch.GitBranchWidget;
import git4idea.update.GitUpdateEnvironment;
import git4idea.util.GitVcsConsoleWriter;
import git4idea.vfs.GitVFSListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcs
extends AbstractVcs<CommittedChangeList> {
    public static final String NAME = "Git";
    public static final String ID = "git";
    private static final Logger LOG = Logger.getInstance((String)GitVcs.class.getName());
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    @Nullable
    private final ChangeProvider myChangeProvider;
    @Nullable
    private final GitCheckinEnvironment myCheckinEnvironment;
    private final RollbackEnvironment myRollbackEnvironment;
    @NotNull
    private final GitExecutableManager myExecutableManager;
    private final GitUpdateEnvironment myUpdateEnvironment;
    private final GitAnnotationProvider myAnnotationProvider;
    private final DiffProvider myDiffProvider;
    private final GitHistoryProvider myHistoryProvider;
    @NotNull
    private final Git myGit;
    private final GitVcsConsoleWriter myVcsConsoleWriter;
    private final RevisionSelector myRevSelector;
    private final GitCommittedChangeListProvider myCommittedChangeListProvider;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock;
    @Nullable
    private final GitCommitAndPushExecutor myCommitAndPushExecutor;
    private final GitExecutableValidator myExecutableValidator;
    private GitBranchWidget myBranchWidget;
    private GitRepositoryForAnnotationsListener myRepositoryForAnnotationsListener;
    private final VcsOutgoingChangesProvider<CommittedChangeList> myOutgoingChangesProvider;

    @NotNull
    public static GitVcs getInstance(@NotNull Project project) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(0);
        }
        GitVcs gitVcs = (GitVcs)((Object)ObjectUtils.notNull((Object)((Object)((GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME)))));
        if (gitVcs == null) {
            GitVcs.$$$reportNull$$$0(1);
        }
        return gitVcs;
    }

    public GitVcs(@NotNull Project project, @NotNull Git git, @NotNull GitVcsConsoleWriter vcsConsoleWriter, @NotNull GitAnnotationProvider gitAnnotationProvider, @NotNull GitDiffProvider gitDiffProvider, @NotNull GitHistoryProvider gitHistoryProvider, @NotNull GitRollbackEnvironment gitRollbackEnvironment, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitExecutableManager executableManager) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(2);
        }
        if (git == null) {
            GitVcs.$$$reportNull$$$0(3);
        }
        if (vcsConsoleWriter == null) {
            GitVcs.$$$reportNull$$$0(4);
        }
        if (gitAnnotationProvider == null) {
            GitVcs.$$$reportNull$$$0(5);
        }
        if (gitDiffProvider == null) {
            GitVcs.$$$reportNull$$$0(6);
        }
        if (gitHistoryProvider == null) {
            GitVcs.$$$reportNull$$$0(7);
        }
        if (gitRollbackEnvironment == null) {
            GitVcs.$$$reportNull$$$0(8);
        }
        if (gitProjectSettings == null) {
            GitVcs.$$$reportNull$$$0(9);
        }
        if (executableManager == null) {
            GitVcs.$$$reportNull$$$0(10);
        }
        super(project, NAME);
        this.myCommandLock = new ReentrantReadWriteLock(true);
        this.myGit = git;
        this.myVcsConsoleWriter = vcsConsoleWriter;
        this.myChangeProvider = project.isDefault() ? null : (ChangeProvider)ServiceManager.getService((Project)project, GitChangeProvider.class);
        this.myCheckinEnvironment = project.isDefault() ? null : (GitCheckinEnvironment)ServiceManager.getService((Project)project, GitCheckinEnvironment.class);
        this.myAnnotationProvider = gitAnnotationProvider;
        this.myDiffProvider = gitDiffProvider;
        this.myHistoryProvider = gitHistoryProvider;
        this.myRollbackEnvironment = gitRollbackEnvironment;
        this.myExecutableManager = executableManager;
        this.myRevSelector = new GitRevisionSelector();
        this.myUpdateEnvironment = new GitUpdateEnvironment(this.myProject, gitProjectSettings);
        this.myCommittedChangeListProvider = new GitCommittedChangeListProvider(this.myProject);
        this.myOutgoingChangesProvider = new GitOutgoingChangesProvider(this.myProject);
        this.myCommitAndPushExecutor = this.myCheckinEnvironment != null ? new GitCommitAndPushExecutor() : null;
        this.myExecutableValidator = new GitExecutableValidator(this.myProject);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task) {
        task.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangeListProvider;
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        MergeProvider mergeProvider = GitMergeProvider.detect(this.myProject);
        if (mergeProvider == null) {
            GitVcs.$$$reportNull$$$0(11);
        }
        return mergeProvider;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            GitVcs.$$$reportNull$$$0(12);
        }
        return rollbackEnvironment;
    }

    @NotNull
    public GitHistoryProvider getVcsHistoryProvider() {
        GitHistoryProvider gitHistoryProvider = this.myHistoryProvider;
        if (gitHistoryProvider == null) {
            GitVcs.$$$reportNull$$$0(13);
        }
        return gitHistoryProvider;
    }

    public GitHistoryProvider getVcsBlockHistoryProvider() {
        return this.myHistoryProvider;
    }

    @NotNull
    public String getDisplayName() {
        if (NAME == null) {
            GitVcs.$$$reportNull$$$0(14);
        }
        return NAME;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @NotNull
    public AnnotationProviderEx getAnnotationProvider() {
        GitAnnotationProvider gitAnnotationProvider = this.myAnnotationProvider;
        if (gitAnnotationProvider == null) {
            GitVcs.$$$reportNull$$$0(15);
        }
        return gitAnnotationProvider;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        DiffProvider diffProvider = this.myDiffProvider;
        if (diffProvider == null) {
            GitVcs.$$$reportNull$$$0(16);
        }
        return diffProvider;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return this.myRevSelector;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getRepositoryForFile(this.myProject, path).getRoot();
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                LOG.info("Unexpected problem with resolving the git revision number: ", (Throwable)e);
                throw e;
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.gitRootOrNull(dir) != null;
    }

    protected void activate() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> this.myExecutableManager.testGitExecutableVersionValid(this.myProject), (ProgressIndicator)new EmptyProgressIndicator()));
        if (this.myVFSListener == null) {
            this.myVFSListener = GitVFSListener.createInstance(this, this.myGit, this.myVcsConsoleWriter);
        }
        ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myBranchWidget = new GitBranchWidget(this.myProject);
            this.myBranchWidget.activate();
        }
        if (this.myRepositoryForAnnotationsListener == null) {
            this.myRepositoryForAnnotationsListener = new GitRepositoryForAnnotationsListener(this.myProject);
        }
        GitUserRegistry.getInstance(this.myProject).activate();
        GitBranchIncomingOutgoingManager.getInstance(this.myProject).activate();
    }

    protected void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myBranchWidget != null) {
            this.myBranchWidget.deactivate();
            this.myBranchWidget = null;
        }
    }

    public Configurable getConfigurable() {
        return null;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public void showErrors(@NotNull List<? extends VcsException> list, @NotNull String action) {
        if (list == null) {
            GitVcs.$$$reportNull$$$0(17);
        }
        if (action == null) {
            GitVcs.$$$reportNull$$$0(18);
        }
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException vcsException : list) {
                buffer.append("\n");
                buffer.append(vcsException.getMessage());
            }
            String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title")));
        }
    }

    @NotNull
    public GitVersion getVersion() {
        GitVersion gitVersion = this.myExecutableManager.getVersion(this.myProject);
        if (gitVersion == null) {
            GitVcs.$$$reportNull$$$0(19);
        }
        return gitVersion;
    }

    @Deprecated
    public void showCommandLine(String cmdLine) {
        this.myVcsConsoleWriter.showCommandLine(cmdLine);
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return this.myOutgoingChangesProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return this.myCommitAndPushExecutor != null ? Collections.singletonList(this.myCommitAndPushExecutor) : Collections.emptyList();
    }

    @Deprecated
    @NotNull
    public GitExecutableValidator getExecutableValidator() {
        GitExecutableValidator gitExecutableValidator = this.myExecutableValidator;
        if (gitExecutableValidator == null) {
            GitVcs.$$$reportNull$$$0(20);
        }
        return gitExecutableValidator;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public void enableIntegration() {
        Runnable task = () -> {
            Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class)).detect();
            new GitIntegrationEnabler(this, this.myGit).enable(roots);
        };
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)task);
    }

    public CheckoutProvider getCheckoutProvider() {
        return new GitCheckoutProvider();
    }

    @Nullable
    public CommittedChangeList loadRevisions(VirtualFile vf, VcsRevisionNumber number) {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf);
        if (repository == null) {
            return null;
        }
        return (CommittedChangeList)VcsSynchronousProgressWrapper.compute(() -> GitCommittedChangeListProvider.getCommittedChangeList(this.myProject, repository.getRoot(), (GitRevisionNumber)number), (Project)this.getProject(), (String)"Load Revision Contents");
    }

    public boolean arePartialChangelistsSupported() {
        return true;
    }

    public GitVFSListener getVFSListener() {
        return this.myVFSListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitVcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsConsoleWriter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitAnnotationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDiffProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitHistoryProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRollbackEnvironment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitProjectSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRollbackEnvironment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsHistoryProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

