/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.HeavyProcessLatch");
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final List<Runnable> toExecuteOutOfHeavyActivity = new ArrayList<Runnable>();

    private HeavyProcessLatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(0);
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        AccessToken accessToken = new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
        if (accessToken == null) {
            HeavyProcessLatch.$$$reportNull$$$0(1);
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinished(@NotNull String operationName) {
        List<Runnable> toRunNow;
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(2);
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove(operationName);
        }
        this.myEventDispatcher.getMulticaster().processFinished();
        Set<String> set2 = this.myHeavyProcesses;
        synchronized (set2) {
            if (this.isRunning()) {
                toRunNow = Collections.emptyList();
            } else {
                toRunNow = new ArrayList<Runnable>(this.toExecuteOutOfHeavyActivity);
                this.toExecuteOutOfHeavyActivity.clear();
            }
        }
        for (Runnable runnable : toRunNow) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningOperationName() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return this.myHeavyProcesses.isEmpty() ? null : this.myHeavyProcesses.iterator().next();
        }
    }

    public void addListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            HeavyProcessLatch.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(4);
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOutOfHeavyProcess(@NotNull Runnable runnable) {
        boolean runNow;
        if (runnable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(5);
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            if (this.isRunning()) {
                runNow = false;
                this.toExecuteOutOfHeavyActivity.add(runnable);
            } else {
                runNow = true;
            }
        }
        if (runNow) {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processStarted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processStarted";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFinished";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

