/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcs.commit.ChangeListCommitState;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u00052\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001c\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!J\u0017\u0010%\u001a\u0004\u0018\u00010\u00182\u0006\u0010&\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\u0018H\u0002J\u0016\u0010.\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "", "project", "Lcom/intellij/openapi/project/Project;", "initialCommitMessage", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "<set-?>", "commitMessage", "getCommitMessage", "()Ljava/lang/String;", "defaultNameChangeListMessage", "getDefaultNameChangeListMessage", "setDefaultNameChangeListMessage", "(Ljava/lang/String;)V", "lastChangeListName", "messagesToSave", "", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "kotlin.jvm.PlatformType", "forgetMessage", "", "()Lkotlin/Unit;", "getCommitMessageFor", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getCommitMessageFromVcs", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "init", "includedChanges", "rememberMessage", "message", "(Ljava/lang/String;)Lkotlin/Unit;", "save", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "success", "", "saveMessages", "update", "currentMessage", "intellij.platform.vcs.impl"})
public final class SingleChangeListCommitMessagePolicy {
    private final VcsConfiguration vcsConfiguration;
    private final ChangeListManager changeListManager;
    @Nullable
    private String defaultNameChangeListMessage;
    private String lastChangeListName;
    private final Map<String, String> messagesToSave;
    @Nullable
    private String commitMessage;
    private final Project project;
    private final String initialCommitMessage;

    @Nullable
    public final String getDefaultNameChangeListMessage() {
        return this.defaultNameChangeListMessage;
    }

    public final void setDefaultNameChangeListMessage(@Nullable String string) {
        this.defaultNameChangeListMessage = string;
    }

    @Nullable
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    public final void init(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> includedChanges) {
        Intrinsics.checkParameterIsNotNull((Object)changeList, (String)"changeList");
        Intrinsics.checkParameterIsNotNull(includedChanges, (String)"includedChanges");
        if (this.vcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        this.lastChangeListName = changeList.getName();
        if (this.initialCommitMessage != null) {
            this.defaultNameChangeListMessage = this.initialCommitMessage;
            this.commitMessage = this.initialCommitMessage;
        } else {
            this.commitMessage = this.getCommitMessageFor(changeList);
            CharSequence charSequence = this.commitMessage;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.defaultNameChangeListMessage = this.vcsConfiguration.LAST_COMMIT_MESSAGE;
                String string = this.getCommitMessageFromVcs(includedChanges);
                if (string == null) {
                    string = this.defaultNameChangeListMessage;
                }
                this.commitMessage = string;
            }
        }
    }

    public final void update(@NotNull LocalChangeList changeList, @NotNull String currentMessage) {
        Intrinsics.checkParameterIsNotNull((Object)changeList, (String)"changeList");
        Intrinsics.checkParameterIsNotNull((Object)currentMessage, (String)"currentMessage");
        this.commitMessage = currentMessage;
        if (this.vcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        if (Intrinsics.areEqual((Object)changeList.getName(), (Object)this.lastChangeListName) ^ true) {
            this.rememberMessage(currentMessage);
            this.lastChangeListName = changeList.getName();
            String string = this.getCommitMessageFor(changeList);
            if (string == null) {
                string = this.defaultNameChangeListMessage;
            }
            this.commitMessage = string;
        }
    }

    public final void save(@NotNull ChangeListCommitState commitState, boolean success2) {
        Intrinsics.checkParameterIsNotNull((Object)commitState, (String)"commitState");
        this.rememberMessage(commitState.getCommitMessage());
        if (success2) {
            boolean entireChangeListIncluded;
            this.vcsConfiguration.saveCommitMessage(commitState.getCommitMessage());
            boolean bl = entireChangeListIncluded = commitState.getChangeList().getChanges().size() == commitState.getChanges().size();
            if (!entireChangeListIncluded) {
                this.forgetMessage();
            }
        }
        this.saveMessages();
    }

    private final String getCommitMessageFor(LocalChangeList changeList) {
        ExtensionPointName<CommitMessageProvider> extensionPointName = CommitMessageProvider.EXTENSION_POINT_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"CommitMessageProvider.EXTENSION_POINT_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"CommitMessageProvider.EX\u2026_POINT_NAME.extensionList");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommitMessageProvider provider = (CommitMessageProvider)element$iv;
            boolean bl = false;
            String providerMessage = provider.getCommitMessage(changeList, this.project);
            if (providerMessage == null) continue;
            return providerMessage;
        }
        String changeListDescription = changeList.getComment();
        CharSequence charSequence = changeListDescription;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return changeListDescription;
        }
        return !changeList.hasDefaultName() ? changeList.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCommitMessageFromVcs(List<? extends Change> changes2) {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ChangesUtil.processChangesByVcs((Project)this.project, (Collection)changes2, (ChangesUtil.PerVcsProcessor)((ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(this, (Ref.ObjectRef)result2){
            final /* synthetic */ SingleChangeListCommitMessagePolicy this$0;
            final /* synthetic */ Ref.ObjectRef $result;

            public final void process(@NotNull AbstractVcs<CommittedChangeList> vcs, @NotNull List<Change> vcsChanges) {
                Intrinsics.checkParameterIsNotNull(vcs, (String)"vcs");
                Intrinsics.checkParameterIsNotNull(vcsChanges, (String)"vcsChanges");
                if ((String)this.$result.element == null) {
                    this.$result.element = SingleChangeListCommitMessagePolicy.access$getCommitMessageFromVcs(this.this$0, vcs, vcsChanges);
                }
            }
            {
                this.this$0 = singleChangeListCommitMessagePolicy;
                this.$result = objectRef;
            }
        }));
        return (String)result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCommitMessageFromVcs(AbstractVcs<?> vcs, List<? extends Change> changes2) {
        String string;
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            void $this$toTypedArray$iv;
            List list = ChangesUtil.getPaths((Collection)changes2);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ChangesUtil.getPaths(changes)");
            Collection collection = list;
            CheckinEnvironment checkinEnvironment2 = checkinEnvironment;
            boolean $i$f$toTypedArray = false;
            void v2 = $this$toTypedArray$iv;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v2;
            FilePath[] filePathArray = thisCollection$iv.toArray(new FilePath[0]);
            if (filePathArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            FilePath[] filePathArray2 = filePathArray;
            string = checkinEnvironment2.getDefaultMessageFor(filePathArray2);
        } else {
            string = null;
        }
        return string;
    }

    private final Unit rememberMessage(String message) {
        Unit unit;
        String string = this.lastChangeListName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.messagesToSave.put(it, message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit forgetMessage() {
        Unit unit;
        String string = this.lastChangeListName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Map<String, String> map2 = this.messagesToSave;
            boolean bl4 = false;
            map2.remove(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void saveMessages() {
        this.messagesToSave.forEach(new BiConsumer<String, String>(this){
            final /* synthetic */ SingleChangeListCommitMessagePolicy this$0;

            public final void accept(@NotNull String changeListName, @NotNull String commitMessage2) {
                Intrinsics.checkParameterIsNotNull((Object)changeListName, (String)"changeListName");
                Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
                SingleChangeListCommitMessagePolicy.access$getChangeListManager$p(this.this$0).editComment(changeListName, commitMessage2);
            }
            {
                this.this$0 = singleChangeListCommitMessagePolicy;
            }
        });
    }

    public SingleChangeListCommitMessagePolicy(@NotNull Project project, @Nullable String initialCommitMessage) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.initialCommitMessage = initialCommitMessage;
        this.vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        this.changeListManager = changeListManager;
        SingleChangeListCommitMessagePolicy singleChangeListCommitMessagePolicy = this;
        boolean bl = false;
        singleChangeListCommitMessagePolicy.messagesToSave = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ String access$getCommitMessageFromVcs(SingleChangeListCommitMessagePolicy $this, AbstractVcs vcs, List changes2) {
        return $this.getCommitMessageFromVcs(vcs, changes2);
    }

    public static final /* synthetic */ ChangeListManager access$getChangeListManager$p(SingleChangeListCommitMessagePolicy $this) {
        return $this.changeListManager;
    }
}

