/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateFileType;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;

public class TextMateCommentProvider
implements MultipleLangCommentProvider,
Commenter {
    @Nullable
    public Commenter getLineCommenter(PsiFile file, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        TextMateCommentPair lineCommentPair = null;
        TextMateCommentPair blockCommentPair = null;
        int index = 1;
        while (blockCommentPair == null || lineCommentPair == null) {
            String variableSuffix = index > 1 ? "_" + index : "";
            TextMateShellVariable start = TextMateService.getInstance().getVariable("TM_COMMENT_START" + variableSuffix, (EditorEx)editor);
            TextMateShellVariable end = TextMateService.getInstance().getVariable("TM_COMMENT_END" + variableSuffix, (EditorEx)editor);
            ++index;
            if (start == null) break;
            if (!(end != null && end.scopeName.equals(start.scopeName) || lineCommentPair != null)) {
                lineCommentPair = new TextMateCommentPair(index, start.value, null);
            }
            if (end == null || !end.scopeName.equals(start.scopeName) || blockCommentPair != null) continue;
            blockCommentPair = new TextMateCommentPair(index, start.value, end.value);
        }
        return lineCommentPair != null || blockCommentPair != null ? new MyCommenter(lineCommentPair, blockCommentPair) : null;
    }

    public boolean canProcess(@NotNull PsiFile file, FileViewProvider viewProvider) {
        if (file == null) {
            TextMateCommentProvider.$$$reportNull$$$0(0);
        }
        return file.getFileType() == TextMateFileType.INSTANCE;
    }

    @Nullable
    public String getLineCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return "";
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return "";
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/textmate/editor/TextMateCommentProvider", "canProcess"));
    }

    public static class TextMateCommentPair
    implements Comparable<TextMateCommentPair> {
        private final int myIndex;
        @NotNull
        public final String startComment;
        @Nullable
        public final String endComment;

        public TextMateCommentPair(int index, @NotNull String startComment, @Nullable String endComment) {
            if (startComment == null) {
                TextMateCommentPair.$$$reportNull$$$0(0);
            }
            this.myIndex = index;
            this.startComment = startComment;
            this.endComment = endComment;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextMateCommentPair pair = (TextMateCommentPair)o;
            if (this.endComment != null ? !this.endComment.equals(pair.endComment) : pair.endComment != null) {
                return false;
            }
            return this.startComment.equals(pair.startComment);
        }

        public int hashCode() {
            int result = this.startComment.hashCode();
            result = 31 * result + (this.endComment != null ? this.endComment.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TextMateCommentPair{startComment='" + this.startComment + '\'' + ", endComment='" + this.endComment + '\'' + '}';
        }

        @Override
        public int compareTo(TextMateCommentPair o) {
            return this.myIndex - o.myIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startComment", "org/jetbrains/plugins/textmate/editor/TextMateCommentProvider$TextMateCommentPair", "<init>"));
        }
    }

    private static class MyCommenter
    implements Commenter {
        @Nullable
        private final TextMateCommentPair myLineCommentPair;
        @Nullable
        private final TextMateCommentPair myBlockCommentPair;

        private MyCommenter(@Nullable TextMateCommentPair lineCommentPair, @Nullable TextMateCommentPair blockCommentPair) {
            this.myLineCommentPair = lineCommentPair;
            this.myBlockCommentPair = blockCommentPair;
        }

        @Nullable
        public String getLineCommentPrefix() {
            return this.myLineCommentPair != null ? this.myLineCommentPair.startComment : null;
        }

        @Nullable
        public String getBlockCommentPrefix() {
            return this.myBlockCommentPair != null ? this.myBlockCommentPair.startComment : null;
        }

        @Nullable
        public String getBlockCommentSuffix() {
            return this.myBlockCommentPair != null ? this.myBlockCommentPair.endComment : null;
        }

        @Nullable
        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        @Nullable
        public String getCommentedBlockCommentSuffix() {
            return null;
        }
    }
}

