/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.VersionSpecific;

class Java9Specific
extends VersionSpecific {
    private static final MethodHandle[][] JDK9_METHODS = Java9Specific.initJdk9Methods();
    private static final int IDX_STREAM = 0;
    private static final int IDX_INT_STREAM = 1;
    private static final int IDX_LONG_STREAM = 2;
    private static final int IDX_DOUBLE_STREAM = 3;
    private static final int IDX_TAKE_WHILE = 0;
    private static final int IDX_DROP_WHILE = 1;

    Java9Specific() {
    }

    static MethodHandle[][] initJdk9Methods() {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType[] types = new MethodType[]{MethodType.methodType(Stream.class, Predicate.class), MethodType.methodType(IntStream.class, IntPredicate.class), MethodType.methodType(LongStream.class, LongPredicate.class), MethodType.methodType(DoubleStream.class, DoublePredicate.class)};
        MethodHandle[][] methods = new MethodHandle[types.length][];
        try {
            int i = 0;
            for (MethodType type : types) {
                methods[i++] = new MethodHandle[]{lookup.findVirtual((Class<?>)type.returnType(), "takeWhile", type), lookup.findVirtual((Class<?>)type.returnType(), "dropWhile", type)};
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        return methods;
    }

    @Override
    <T, S extends AbstractStreamEx<T, S>> S callWhile(AbstractStreamEx<T, S> stream, Predicate<? super T> predicate, boolean drop) {
        try {
            return stream.supply(JDK9_METHODS[0][drop ? 1 : 0].invokeExact((Stream)stream.stream(), predicate));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    final IntStreamEx callWhile(IntStreamEx stream, IntPredicate predicate, boolean drop) {
        try {
            return new IntStreamEx(JDK9_METHODS[1][drop ? 1 : 0].invokeExact((IntStream)stream.stream(), predicate), stream.context);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    final LongStreamEx callWhile(LongStreamEx stream, LongPredicate predicate, boolean drop) {
        try {
            return new LongStreamEx(JDK9_METHODS[2][drop ? 1 : 0].invokeExact((LongStream)stream.stream(), predicate), stream.context);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    final DoubleStreamEx callWhile(DoubleStreamEx stream, DoublePredicate predicate, boolean drop) {
        try {
            return new DoubleStreamEx(JDK9_METHODS[3][drop ? 1 : 0].invokeExact((DoubleStream)stream.stream(), predicate), stream.context);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    IntStream ofChars(CharSequence seq) {
        return seq.chars();
    }
}

