/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonReader;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

final class DiffHttpService
extends RestService {
    DiffHttpService() {
    }

    @Override
    @NotNull
    protected String getServiceName() {
        if ("diff" == null) {
            DiffHttpService.$$$reportNull$$$0(0);
        }
        return "diff";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            DiffHttpService.$$$reportNull$$$0(1);
        }
        return method == HttpMethod.POST;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            DiffHttpService.$$$reportNull$$$0(2);
        }
        if (request == null) {
            DiffHttpService.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DiffHttpService.$$$reportNull$$$0(4);
        }
        ArrayList contents = new ArrayList();
        ArrayList titles = new ArrayList();
        boolean focused = true;
        String windowTitle = null;
        JsonReader reader = DiffHttpService.createJsonReader(request);
        if (reader.hasNext()) {
            String fileType = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("fileType")) {
                    fileType = reader.nextString();
                    continue;
                }
                if (name.equals("focused")) {
                    focused = reader.nextBoolean();
                    continue;
                }
                if (name.equals("windowTitle")) {
                    windowTitle = StringUtil.nullize((String)reader.nextString(), (boolean)true);
                    continue;
                }
                if (name.equals("contents")) {
                    String error = DiffHttpService.readContent(reader, contents, titles, fileType);
                    if (error == null) continue;
                    return error;
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        if (contents.isEmpty()) {
            return "Empty request";
        }
        Project project = DiffHttpService.getLastFocusedOrOpenedProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        boolean finalFocused = focused;
        String finalWindowTitle = windowTitle;
        Project finalProject = project;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalFocused) {
                ProjectUtil.focusProjectWindow(finalProject, true);
            }
            DiffManager.getInstance().showDiff(finalProject, (DiffRequest)new SimpleDiffRequest(StringUtil.notNullize((String)finalWindowTitle, (String)"Diff Service"), contents, titles));
        }, project.getDisposed());
        DiffHttpService.sendOk(request, context);
        return null;
    }

    @Nullable
    private static String readContent(@NotNull JsonReader reader, @NotNull List<? super DiffContent> contents, @NotNull List<? super String> titles, @Nullable String defaultFileTypeName) throws IOException {
        if (reader == null) {
            DiffHttpService.$$$reportNull$$$0(5);
        }
        if (contents == null) {
            DiffHttpService.$$$reportNull$$$0(6);
        }
        if (titles == null) {
            DiffHttpService.$$$reportNull$$$0(7);
        }
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        FileType defaultFileType = defaultFileTypeName == null ? null : fileTypeRegistry.findFileTypeByName(defaultFileTypeName);
        reader.beginArray();
        while (reader.hasNext()) {
            String title = null;
            String fileType = null;
            String content2 = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("title")) {
                    title = reader.nextString();
                    continue;
                }
                if (name.equals("fileType")) {
                    fileType = reader.nextString();
                    continue;
                }
                if (name.equals("content")) {
                    content2 = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            if (content2 == null) {
                return "content is not specified";
            }
            FileType type = fileType == null ? defaultFileType : fileTypeRegistry.findFileTypeByName(fileType);
            contents.add((DiffContent)DiffContentFactory.getInstance().create(content2, type));
            titles.add(StringUtil.isEmptyOrSpaces((String)title) ? "" : title);
        }
        reader.endArray();
        return null;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        if (request == null) {
            DiffHttpService.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ide/DiffHttpService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDecoder";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ide/DiffHttpService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMethodSupported";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

