/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorSettingsTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FileColorsConfigurablePanel
extends JPanel
implements Disposable {
    private FileColorManagerImpl myManager;
    private final JCheckBox myEnabledCheckBox;
    private final JCheckBox myTabsEnabledCheckBox;
    private final JCheckBox myProjectViewEnabledCheckBox;
    private final FileColorSettingsTable myLocalTable;
    private final FileColorSettingsTable mySharedTable;

    public FileColorsConfigurablePanel(final @NotNull FileColorManagerImpl manager) {
        if (manager == null) {
            FileColorsConfigurablePanel.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        this.myManager = manager;
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.myEnabledCheckBox = new JCheckBox("Enable File Colors");
        this.myEnabledCheckBox.setMnemonic('F');
        topPanel.add(this.myEnabledCheckBox);
        topPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        this.myTabsEnabledCheckBox = new JCheckBox("Use in Editor Tabs");
        this.myTabsEnabledCheckBox.setMnemonic('T');
        topPanel.add(this.myTabsEnabledCheckBox);
        topPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        this.myProjectViewEnabledCheckBox = new JCheckBox("Use in Project View");
        this.myProjectViewEnabledCheckBox.setMnemonic('P');
        topPanel.add(this.myProjectViewEnabledCheckBox);
        topPanel.add(Box.createHorizontalGlue());
        this.add((Component)topPanel, "North");
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        mainPanel.setPreferredSize((Dimension)JBUI.size((int)300, (int)500));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        List<FileColorConfiguration> localConfigurations = manager.getApplicationLevelConfigurations();
        this.myLocalTable = new FileColorSettingsTable(manager, localConfigurations){

            @Override
            protected void apply(@NotNull List<? extends FileColorConfiguration> configurations) {
                if (configurations == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<FileColorConfiguration> copied = new ArrayList<FileColorConfiguration>();
                try {
                    for (FileColorConfiguration fileColorConfiguration : configurations) {
                        copied.add(fileColorConfiguration.clone());
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                manager.getModel().setConfigurations(copied, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/ui/tabs/FileColorsConfigurablePanel$1", "apply"));
            }
        };
        JPanel panel2 = ToolbarDecorator.createDecorator((JTable)((Object)this.myLocalTable)).addExtraAction(new AnActionButton("Share", AllIcons.Actions.Share){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileColorsConfigurablePanel.this.share();
            }

            public boolean isEnabled() {
                return super.isEnabled() && FileColorsConfigurablePanel.this.myLocalTable.getSelectedRow() != -1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/tabs/FileColorsConfigurablePanel$2", "actionPerformed"));
            }
        }).createPanel();
        JPanel localPanel = new JPanel(new BorderLayout());
        localPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Local colors", (boolean)false));
        localPanel.add((Component)panel2, "Center");
        mainPanel.add(localPanel);
        this.mySharedTable = new FileColorSettingsTable(manager, manager.getProjectLevelConfigurations()){

            @Override
            protected void apply(@NotNull List<? extends FileColorConfiguration> configurations) {
                if (configurations == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrayList<FileColorConfiguration> copied = new ArrayList<FileColorConfiguration>();
                for (FileColorConfiguration fileColorConfiguration : configurations) {
                    try {
                        copied.add(fileColorConfiguration.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        assert (false) : "Should not happen!";
                    }
                }
                manager.getModel().setConfigurations(copied, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/ui/tabs/FileColorsConfigurablePanel$3", "apply"));
            }
        };
        JPanel sharedPanel = new JPanel(new BorderLayout());
        sharedPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Shared colors", (boolean)false));
        JPanel shared = ToolbarDecorator.createDecorator((JTable)((Object)this.mySharedTable)).addExtraAction(new AnActionButton("Unshare", AllIcons.Actions.Unshare){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                FileColorsConfigurablePanel.this.unshare();
            }

            public boolean isEnabled() {
                return super.isEnabled() && FileColorsConfigurablePanel.this.mySharedTable.getSelectedRow() != -1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/tabs/FileColorsConfigurablePanel$4", "actionPerformed"));
            }
        }).createPanel();
        sharedPanel.add((Component)shared, "Center");
        mainPanel.add(sharedPanel);
        this.add((Component)mainPanel, "Center");
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        infoPanel.add(new JLabel("Scopes are processed from top to bottom with Local colors first.", MessageType.INFO.getDefaultIcon(), 2));
        JButton editScopes = new JButton("Manage Scopes...");
        editScopes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                EditScopesDialog.showDialog(FileColorsConfigurablePanel.this.myManager.getProject(), null, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/tabs/FileColorsConfigurablePanel$5", "actionPerformed"));
            }
        });
        infoPanel.add((Component)editScopes, "East");
        this.add((Component)infoPanel, "South");
        this.myLocalTable.getEmptyText().setText("No local colors");
        this.mySharedTable.getEmptyText().setText("No shared colors");
    }

    private void unshare() {
        int rowCount = this.mySharedTable.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.mySharedTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                FileColorConfiguration removed = this.mySharedTable.removeConfiguration(rows[i]);
                if (removed == null) continue;
                this.myLocalTable.addConfiguration(removed);
            }
        }
    }

    private void share() {
        int rowCount = this.myLocalTable.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.myLocalTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                FileColorConfiguration removed = this.myLocalTable.removeConfiguration(rows[i]);
                if (removed == null) continue;
                this.mySharedTable.addConfiguration(removed);
            }
        }
    }

    public void dispose() {
        this.myManager = null;
    }

    public boolean isModified() {
        boolean modified = this.myEnabledCheckBox.isSelected() != this.myManager.isEnabled();
        modified |= this.myTabsEnabledCheckBox.isSelected() != this.myManager.isEnabledForTabs();
        modified |= this.myProjectViewEnabledCheckBox.isSelected() != this.myManager.isEnabledForProjectView();
        return modified |= this.myLocalTable.isModified() || this.mySharedTable.isModified();
    }

    public void apply() {
        this.myManager.setEnabled(this.myEnabledCheckBox.isSelected());
        this.myManager.setEnabledForTabs(this.myTabsEnabledCheckBox.isSelected());
        FileColorManagerImpl.setEnabledForProjectView(this.myProjectViewEnabledCheckBox.isSelected());
        this.myLocalTable.apply();
        this.mySharedTable.apply();
        UISettings.getInstance().fireUISettingsChanged();
    }

    public void reset() {
        this.myEnabledCheckBox.setSelected(this.myManager.isEnabled());
        this.myTabsEnabledCheckBox.setSelected(this.myManager.isEnabledForTabs());
        this.myProjectViewEnabledCheckBox.setSelected(this.myManager.isEnabledForProjectView());
        if (this.myLocalTable.isModified()) {
            this.myLocalTable.reset();
        }
        if (this.mySharedTable.isModified()) {
            this.mySharedTable.reset();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/tabs/FileColorsConfigurablePanel", "<init>"));
    }
}

