/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ChildInfoImpl
implements ChildInfo {
    public static final int UNKNOWN_ID_YET = -1;
    private final int id;
    private final int nameId;
    private final String symLinkTarget;
    @Nullable
    private final ChildInfo[] children;
    private final byte fileAttributesType;
    @FileAttributes.Flags
    private final byte flags;
    private final long length;
    private final long lastModified;

    public ChildInfoImpl(int id, @NotNull String name, @Nullable FileAttributes attributes, @Nullable ChildInfo[] children2, @Nullable String symLinkTarget) {
        if (name == null) {
            ChildInfoImpl.$$$reportNull$$$0(0);
        }
        this(id, FileNameCache.storeName(name), attributes, children2, symLinkTarget);
    }

    public ChildInfoImpl(int id, int nameId, @Nullable FileAttributes attributes, @Nullable ChildInfo[] children2, @Nullable String symLinkTarget) {
        this.nameId = nameId;
        this.id = id;
        this.children = children2;
        this.symLinkTarget = symLinkTarget;
        if (id <= 0 && id != -1) {
            throw new IllegalArgumentException("expected id > 0, got: " + id);
        }
        if (attributes == null) {
            this.fileAttributesType = (byte)-1;
            this.flags = (byte)-1;
            this.length = 0L;
            this.lastModified = 0L;
        } else {
            this.fileAttributesType = (byte)(attributes.type == null ? -1 : (byte)attributes.type.ordinal());
            this.flags = attributes.flags;
            this.length = attributes.length;
            this.lastModified = attributes.lastModified;
        }
    }

    public String toString() {
        return this.nameId + " id: " + this.id + " (" + this.getFileAttributes() + ")" + (this.children == null ? "" : "\n  " + StringUtil.join((Object[])this.children, info -> info.toString().replaceAll("\n", "\n  "), (String)"\n  "));
    }

    public FileAttributes getFileAttributes() {
        return this.flags == -1 ? null : FileAttributes.createFrom((byte)this.fileAttributesType, (byte)this.flags, (long)this.length, (long)this.lastModified);
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public CharSequence getName() {
        CharSequence charSequence = FileNameCache.getVFileName(this.nameId);
        if (charSequence == null) {
            ChildInfoImpl.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getNameId() {
        return this.nameId;
    }

    public String getSymLinkTarget() {
        return this.symLinkTarget;
    }

    @Nullable
    public ChildInfo[] getChildren() {
        return this.children;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/ChildInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/ChildInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

