/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchResultsPanel;

import com.intellij.largeFilesEditor.GuiUtils;
import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.editor.EditorManager;
import com.intellij.largeFilesEditor.editor.EditorManagerAccessor;
import com.intellij.largeFilesEditor.search.SearchManager;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.actions.FindFurtherAction;
import com.intellij.largeFilesEditor.search.actions.StopRangeSearchAction;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.RangeSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SingleSelectionModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResultsToolWindow
extends SimpleToolWindowPanel {
    public static final Key<SearchResultsToolWindow> KEY = new Key("lfe.searchResultsToolWindow");
    private static final Logger logger = Logger.getInstance(SearchResultsToolWindow.class);
    private static final String ACTION_TOOLBAR_PLACE_ID = "lfe.searchResultsToolWindow.actionToolbar";
    private static final long UNDEFINED = -1L;
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final EditorManagerAccessor myEditorManagerAccessor;
    private Content myRelativeTab;
    private SearchTaskOptions mySearchTaskOptions;
    private long myLeftBorderPageNumber;
    private long myRightBorderPageNumber;
    private final CollectionListModel<SearchResult> myResultsListModel;
    private final ShowingListModel myShowingListModel;
    private final JBList<ListElementWrapper> myShowingResultsList;
    private final SimpleColoredComponent lblSearchStatusLeft;
    private final SimpleColoredComponent lblSearchStatusCenter;
    private final AnimatedProgressIcon progressIcon;
    private final ActionToolbar myActionToolbar;

    public boolean isButtonFindFurtherEnabled(boolean directionForward) {
        if (directionForward) {
            return this.myShowingListModel.btnSearchForwardWrapper.isEnabled;
        }
        return this.myShowingListModel.btnSearchBackwardWrapper.isEnabled;
    }

    public void onClickSearchFurther(boolean directionForward, boolean additionMode) {
        int listSize = this.myShowingResultsList.getItemsCount();
        if (listSize > 0) {
            int indexToSelect = directionForward ? listSize - 1 : 0;
            this.myShowingResultsList.setSelectedIndex(indexToSelect);
            this.myShowingResultsList.ensureIndexIsVisible(indexToSelect);
        }
        this.launchSearchingFurther(directionForward, additionMode);
    }

    public SearchResultsToolWindow(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull EditorManagerAccessor editorManagerAccessor) {
        if (virtualFile == null) {
            SearchResultsToolWindow.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SearchResultsToolWindow.$$$reportNull$$$0(1);
        }
        if (editorManagerAccessor == null) {
            SearchResultsToolWindow.$$$reportNull$$$0(2);
        }
        super(false, true);
        this.myRelativeTab = null;
        this.mySearchTaskOptions = null;
        this.myLeftBorderPageNumber = -1L;
        this.myRightBorderPageNumber = -1L;
        this.myVirtualFile = virtualFile;
        this.myProject = project;
        this.myEditorManagerAccessor = editorManagerAccessor;
        this.lblSearchStatusLeft = new SimpleColoredComponent();
        this.lblSearchStatusLeft.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.lblSearchStatusCenter = new SimpleColoredComponent();
        this.progressIcon = new AnimatedProgressIcon();
        this.myResultsListModel = new CollectionListModel((Object[])new SearchResult[0]);
        this.myShowingListModel = new ShowingListModel(this.myResultsListModel);
        this.myShowingResultsList = new JBList((ListModel)this.myShowingListModel);
        this.myShowingResultsList.setSelectionModel((ListSelectionModel)new SingleSelectionModel());
        this.myShowingResultsList.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = SearchResultsToolWindow.this.myShowingResultsList.locationToIndex(e.getPoint())) != -1) {
                    ListElementWrapper element = (ListElementWrapper)SearchResultsToolWindow.this.myShowingResultsList.getModel().getElementAt(index);
                    element.onSelected();
                }
            }
        });
        this.myShowingResultsList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ListElementWrapper element;
                if (e.getKeyCode() == 10 && (element = (ListElementWrapper)SearchResultsToolWindow.this.myShowingResultsList.getSelectedValue()) != null) {
                    element.onSelected();
                }
            }
        });
        this.myShowingResultsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<ListElementWrapper>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ListElementWrapper> list2, ListElementWrapper value, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                value.render(this, selected2, hasFocus);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/largeFilesEditor/search/searchResultsPanel/SearchResultsToolWindow$3", "customizeCellRenderer"));
            }
        });
        FindFurtherAction action1 = new FindFurtherAction(false, true, this);
        FindFurtherAction action4 = new FindFurtherAction(true, true, this);
        StopRangeSearchAction action5 = new StopRangeSearchAction(this, editorManagerAccessor);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)action1);
        actionGroup.add((AnAction)action4);
        actionGroup.add((AnAction)new Separator());
        actionGroup.add((AnAction)action5);
        this.myActionToolbar = ActionManager.getInstance().createActionToolbar(ACTION_TOOLBAR_PLACE_ID, (ActionGroup)actionGroup, false);
        JPanel mainPanel = new JPanel();
        JPanel panelResultsList = new JPanel();
        JPanel panelHeader = new JPanel();
        JPanel actionToolbarPanel = new JPanel();
        this.setContent(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)panelHeader, "North");
        mainPanel.add((Component)actionToolbarPanel, "West");
        mainPanel.add((Component)panelResultsList, "Center");
        FlowLayout panelHeaderFlowLayout = new FlowLayout();
        panelHeaderFlowLayout.setAlignment(0);
        panelHeaderFlowLayout.setHgap(0);
        panelHeader.setLayout(panelHeaderFlowLayout);
        panelHeader.add((Component)this.lblSearchStatusLeft);
        panelHeader.add((Component)this.lblSearchStatusCenter);
        panelHeader.add((Component)((Object)this.progressIcon));
        actionToolbarPanel.setLayout(new BorderLayout());
        actionToolbarPanel.add(this.myActionToolbar.getComponent());
        JBScrollPane resultsListScrollPane = new JBScrollPane();
        resultsListScrollPane.setViewportView(this.myShowingResultsList);
        panelResultsList.setLayout(new BorderLayout());
        panelResultsList.add((Component)resultsListScrollPane, "Center");
        GuiUtils.setStandardSizeForPanel(panelHeader, true);
        GuiUtils.setStandardSizeForPanel(actionToolbarPanel, false);
        GuiUtils.setStandardLineBorderToPanel(panelHeader, 0, 0, 1, 0);
        GuiUtils.setStandardLineBorderToPanel(actionToolbarPanel, 0, 0, 0, 1);
    }

    public void setRelativeTab(Content content2) {
        this.myRelativeTab = content2;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public int getAmountOfStoredSearchResults() {
        return this.myResultsListModel.getSize();
    }

    public void setSearchTaskOptions(SearchTaskOptions searchTaskOptions) {
        this.mySearchTaskOptions = searchTaskOptions;
    }

    public void setLeftBorderPageNumber(long leftBorderPageNumber) {
        this.myLeftBorderPageNumber = leftBorderPageNumber;
        this.updateStatusStringInfo();
    }

    public void setRightBorderPageNumber(long rightBorderPageNumber) {
        this.myRightBorderPageNumber = rightBorderPageNumber;
        this.updateStatusStringInfo();
    }

    public void setAdditionalStatusText(@Nullable String statusText) {
        this.lblSearchStatusCenter.clear();
        if (statusText != null) {
            this.lblSearchStatusCenter.append(statusText);
        }
        this.progressIcon.update();
    }

    public void clearAllResults() {
        this.myResultsListModel.removeAll();
    }

    public void addSearchResultsIntoBeginning(List<SearchResult> searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return;
        }
        int oldSelectedIndex = this.myShowingResultsList.getSelectedIndex();
        ListElementWrapper oldSelectedValue = (ListElementWrapper)this.myShowingResultsList.getSelectedValue();
        this.myResultsListModel.addAll(0, searchResults);
        if (this.myShowingResultsList.getSelectedValue() != oldSelectedValue) {
            for (int i = -1; i <= 1; ++i) {
                int probablySelectedIndex = oldSelectedIndex + searchResults.size() + i;
                if (this.myShowingListModel.getElementAt(probablySelectedIndex) != oldSelectedValue) continue;
                this.myShowingResultsList.setSelectedIndex(probablySelectedIndex);
                break;
            }
        }
        Rectangle cellBounds = this.myShowingResultsList.getCellBounds(0, 0);
        int cellHeight = cellBounds.height;
        int additionalHeight = cellHeight * searchResults.size();
        Rectangle visibleRect = this.myShowingResultsList.getVisibleRect();
        visibleRect.y += additionalHeight;
        this.myShowingResultsList.scrollRectToVisible(visibleRect);
    }

    public void addSearchResultsIntoEnd(List<SearchResult> searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return;
        }
        int oldSelectedIndex = this.myShowingResultsList.getSelectedIndex();
        this.myResultsListModel.add(searchResults);
        if (this.myShowingResultsList.getSelectedIndex() != oldSelectedIndex) {
            this.myShowingResultsList.setSelectedIndex(oldSelectedIndex);
        }
    }

    public void updateTabName() {
        if (this.myRelativeTab != null && this.mySearchTaskOptions != null && this.mySearchTaskOptions.stringToFind != null) {
            String name = "\"" + this.mySearchTaskOptions.stringToFind + "\" in " + this.myVirtualFile.getName();
            this.myRelativeTab.setDisplayName(name);
            this.myRelativeTab.setDescription(name);
        }
    }

    public void updateSearchFurtherBtns() {
        try {
            EditorManager editorManager = this.myEditorManagerAccessor.getEditorManager(false, this.myProject, this.myVirtualFile);
            if (editorManager != null) {
                this.myShowingListModel.setSearchFurtherBtnsEnabled(false, this.canFindFurtherBackward());
                this.myShowingListModel.setSearchFurtherBtnsEnabled(true, this.canFindFurtherForward(editorManager.getFileDataProviderForSearch()));
            } else {
                this.myShowingListModel.setSearchFurtherBtnsEnabled(false, false);
                this.myShowingListModel.setSearchFurtherBtnsEnabled(true, false);
            }
        }
        catch (IOException e) {
            logger.info((Throwable)e);
            Messages.showWarningDialog((String)"Working with file error.", (String)"Error");
        }
        this.myActionToolbar.updateActionsImmediately();
        SwingUtilities.updateComponentTreeUI(this.myShowingResultsList);
        this.progressIcon.update();
    }

    public void tellWasClosed() {
        EditorManager editorManager = this.myEditorManagerAccessor.getEditorManager(false, this.myProject, this.myVirtualFile);
        if (editorManager != null) {
            editorManager.getSearchManager().tellSearchResultsToolWindowWasClosed();
        }
    }

    private boolean canFindFurtherBackward() {
        return this.myLeftBorderPageNumber != -1L && this.myLeftBorderPageNumber > 0L;
    }

    private boolean canFindFurtherForward(FileDataProviderForSearch fileDataProviderForSearch) throws IOException {
        long pagesAmount = fileDataProviderForSearch.getPagesAmount();
        return this.myRightBorderPageNumber != -1L && this.myRightBorderPageNumber < pagesAmount - 1L;
    }

    private void launchSearchingFurther(boolean directionForward, boolean additionMode) {
        SearchTaskOptions newOptions;
        EditorManager editorManager = this.myEditorManagerAccessor.getEditorManager(true, this.myProject, this.myVirtualFile);
        if (editorManager == null) {
            logger.warn("Can't open Large File Editor for target file.");
            Messages.showWarningDialog((String)"Can't open Large File Editor for target file.", (String)"Error");
            return;
        }
        try {
            newOptions = this.mySearchTaskOptions.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Throwable)e);
            Messages.showWarningDialog((String)"Can't launch searching because of unexpected error.", (String)"Error");
            return;
        }
        if (additionMode) {
            newOptions.setCriticalAmountOfSearchResults(this.myResultsListModel.getSize() + 1000);
        } else {
            newOptions.setCriticalAmountOfSearchResults(1000);
        }
        if (directionForward) {
            newOptions.setSearchDirectionForward(true).setSearchBounds(this.myRightBorderPageNumber + 1L, -1, -1L, -1);
        } else {
            newOptions.setSearchDirectionForward(false).setSearchBounds(-1L, -1, this.myLeftBorderPageNumber - 1L, -1);
        }
        editorManager.getSearchManager().launchRangeSearch(newOptions, !additionMode);
    }

    private void updateStatusStringInfo() {
        this.lblSearchStatusLeft.clear();
        long pagesAmount = -1L;
        EditorManager editorManager = this.myEditorManagerAccessor.getEditorManager(false, this.myProject, this.myVirtualFile);
        if (editorManager != null) {
            try {
                pagesAmount = editorManager.getFileDataProviderForSearch().getPagesAmount();
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
        }
        this.lblSearchStatusLeft.append(String.format("Found %d matches", this.getAmountOfStoredSearchResults()));
        if (pagesAmount == -1L || this.myRightBorderPageNumber == -1L || this.myLeftBorderPageNumber == -1L) {
            this.lblSearchStatusLeft.append(".");
            return;
        }
        if (this.myLeftBorderPageNumber == 0L && this.myRightBorderPageNumber == pagesAmount - 1L) {
            this.lblSearchStatusLeft.append(" in the whole file.");
        } else {
            this.lblSearchStatusLeft.append(" in bounds ");
            this.lblSearchStatusLeft.append(String.valueOf(Utils.calculatePagePositionPercent(this.myLeftBorderPageNumber, pagesAmount)));
            this.lblSearchStatusLeft.append("% to ");
            this.lblSearchStatusLeft.append(String.valueOf(Utils.calculatePagePositionPercent(this.myRightBorderPageNumber, pagesAmount)));
            this.lblSearchStatusLeft.append("% of file.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "editorManagerAccessor";
                break;
            }
        }
        objectArray[1] = "com/intellij/largeFilesEditor/search/searchResultsPanel/SearchResultsToolWindow";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AnimatedProgressIcon
    extends AsyncProcessIcon {
        AnimatedProgressIcon() {
            super("");
        }

        void update() {
            SearchManager searchManager;
            SearchTaskBase task2;
            boolean enabled = false;
            EditorManager editorManager = SearchResultsToolWindow.this.myEditorManagerAccessor.getEditorManager(false, SearchResultsToolWindow.this.getProject(), SearchResultsToolWindow.this.getVirtualFile());
            if (editorManager != null && (task2 = (searchManager = editorManager.getSearchManager()).getLastExecutedSearchTask()) instanceof RangeSearchTask && !task2.isFinished() && !task2.isShouldStop()) {
                enabled = true;
            }
            if (enabled) {
                this.setVisible(true);
                this.resume();
            } else {
                this.setVisible(false);
                this.suspend();
            }
        }
    }

    private class ShowingListModel
    implements ListModel<ListElementWrapper> {
        private final CollectionListModel<SearchResult> mySearchResultsListModel;
        private final SearchFurtherBtnWrapper btnSearchBackwardWrapper;
        private final SearchFurtherBtnWrapper btnSearchForwardWrapper;

        ShowingListModel(CollectionListModel<SearchResult> model2) {
            this.btnSearchBackwardWrapper = new SearchFurtherBtnWrapper(false);
            this.btnSearchForwardWrapper = new SearchFurtherBtnWrapper(true);
            this.mySearchResultsListModel = model2;
        }

        @Override
        public int getSize() {
            int resultSize = this.mySearchResultsListModel.getSize();
            if (this.btnSearchBackwardWrapper.isEnabled) {
                ++resultSize;
            }
            if (this.btnSearchForwardWrapper.isEnabled) {
                ++resultSize;
            }
            return resultSize;
        }

        @Override
        public ListElementWrapper getElementAt(int index) {
            if (this.btnSearchBackwardWrapper.isEnabled) {
                if (index == 0) {
                    return this.btnSearchBackwardWrapper;
                }
                if (index == this.mySearchResultsListModel.getSize() + 1) {
                    return this.btnSearchForwardWrapper;
                }
                return new SearchResultWrapper((SearchResult)this.mySearchResultsListModel.getElementAt(index - 1));
            }
            if (index == this.mySearchResultsListModel.getSize()) {
                return this.btnSearchForwardWrapper;
            }
            return new SearchResultWrapper((SearchResult)this.mySearchResultsListModel.getElementAt(index));
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.mySearchResultsListModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.mySearchResultsListModel.removeListDataListener(l);
        }

        void setSearchFurtherBtnsEnabled(boolean forwardDirection, boolean enabled) {
            if (forwardDirection) {
                this.btnSearchForwardWrapper.setEnabled(enabled);
            } else {
                this.btnSearchBackwardWrapper.setEnabled(enabled);
            }
        }
    }

    private class SearchFurtherBtnWrapper
    implements ListElementWrapper {
        private final SimpleTextAttributes linkText = new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkPressedColor());
        private final boolean isForwardDirection;
        private boolean isEnabled = false;

        SearchFurtherBtnWrapper(boolean isForwardDirection) {
            this.isForwardDirection = isForwardDirection;
        }

        @Override
        public void render(ColoredListCellRenderer coloredListCellRenderer, boolean selected2, boolean hasFocus) {
            String text2 = this.isForwardDirection ? "find next matches" : "find previous matches";
            if (selected2) {
                coloredListCellRenderer.append(text2);
            } else {
                coloredListCellRenderer.append(text2, this.linkText);
            }
            coloredListCellRenderer.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
        }

        @Override
        public void onSelected() {
            if (this.isEnabled) {
                SearchResultsToolWindow.this.onClickSearchFurther(this.isForwardDirection, true);
            } else {
                logger.warn("[Large File Editor Subsystem] SearchResultsToolWindow.SearchFurtherBtnWrapper.onSelected(): called onSelected() on disabled element, which should be hidden.");
            }
        }

        void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }
    }

    private class SearchResultWrapper
    implements ListElementWrapper {
        private final SimpleTextAttributes attrForMatchers = new SimpleTextAttributes(64, null);
        private final SearchResult mySearchResult;

        SearchResultWrapper(SearchResult mySearchResult) {
            this.mySearchResult = mySearchResult;
        }

        @Override
        public void render(ColoredListCellRenderer coloredListCellRenderer, boolean selected2, boolean hasFocus) {
            coloredListCellRenderer.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
            coloredListCellRenderer.append(this.mySearchResult.contextPrefix);
            coloredListCellRenderer.append(this.mySearchResult.stringToFind, this.attrForMatchers);
            coloredListCellRenderer.append(this.mySearchResult.contextPostfix);
        }

        @Override
        public void onSelected() {
            EditorManager editorManager = SearchResultsToolWindow.this.myEditorManagerAccessor.getEditorManager(true, SearchResultsToolWindow.this.myProject, SearchResultsToolWindow.this.myVirtualFile);
            if (editorManager != null) {
                SearchResultsToolWindow.this.myEditorManagerAccessor.showEditorTab(editorManager);
                editorManager.showSearchResult(this.mySearchResult);
            }
        }
    }

    private static interface ListElementWrapper {
        public void render(ColoredListCellRenderer var1, boolean var2, boolean var3);

        public void onSelected();
    }
}

