/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.yaml.LightScalarResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v1.api.LoadSettings;
import org.snakeyaml.engine.v1.api.LoadSettingsBuilder;
import org.snakeyaml.engine.v1.composer.Composer;
import org.snakeyaml.engine.v1.nodes.MappingNode;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.nodes.NodeTuple;
import org.snakeyaml.engine.v1.nodes.ScalarNode;
import org.snakeyaml.engine.v1.parser.Parser;
import org.snakeyaml.engine.v1.parser.ParserImpl;
import org.snakeyaml.engine.v1.scanner.StreamReader;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"fileExtensions", "", "", "filePrefix", "doRead", "Lorg/snakeyaml/engine/v1/nodes/MappingNode;", "reader", "Ljava/io/Reader;", "findConfigurationFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "findValueNodeByPath", "namePath", "rootNode", "isConfigurationFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "", "intellij.configurationScript"})
public final class ConfigurationFileManagerKt {
    private static final String filePrefix = "intellij.";
    private static final List<String> fileExtensions = CollectionsKt.listOf((Object[])new String[]{"yaml", "yml", "json"});

    @Nullable
    public static final MappingNode findValueNodeByPath(@NotNull String namePath, @NotNull MappingNode rootNode) {
        Intrinsics.checkParameterIsNotNull((Object)namePath, (String)"namePath");
        Intrinsics.checkParameterIsNotNull((Object)rootNode, (String)"rootNode");
        MappingNode node = rootNode;
        block0: for (String name : StringsKt.splitToSequence$default((CharSequence)namePath, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)) {
            Iterator<NodeTuple> iterator = node.getValue().iterator();
            while (iterator.hasNext()) {
                NodeTuple tuple;
                NodeTuple nodeTuple = tuple = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeTuple, (String)"tuple");
                Node keyNode = nodeTuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode) || !Intrinsics.areEqual((Object)((ScalarNode)keyNode).getValue(), (Object)name)) continue;
                Node node2 = tuple.getValueNode();
                if (!(node2 instanceof MappingNode)) {
                    node2 = null;
                }
                if ((MappingNode)node2 != null) continue block0;
            }
            return null;
        }
        return node == rootNode ? null : node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MappingNode doRead(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Closeable closeable = reader;
        boolean bl = false;
        Throwable throwable = null;
        try {
            Reader it = (Reader)closeable;
            boolean bl2 = false;
            LoadSettings settings = new LoadSettingsBuilder().setUseMarks(false).setScalarResolver(new LightScalarResolver()).build();
            Parser parser = new ParserImpl(new StreamReader(it, settings), settings);
            LoadSettings loadSettings = settings;
            Intrinsics.checkExpressionValueIsNotNull((Object)loadSettings, (String)"settings");
            Object v2 = new Composer(parser, loadSettings.getScalarResolver()).getSingleNode().orElse(null);
            if (!(v2 instanceof MappingNode)) {
                v2 = null;
            }
            MappingNode mappingNode = v2;
            return mappingNode;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean isConfigurationFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.nameSequence");
        return ConfigurationFileManagerKt.isConfigurationFile(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isConfigurationFile(@NotNull CharSequence name) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!StringsKt.startsWith$default((CharSequence)name, (CharSequence)filePrefix, (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = fileExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (name.length() == filePrefix.length() + it.length() && StringsKt.endsWith$default((CharSequence)name, (CharSequence)it, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final Path findConfigurationFile(Project project) {
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        Path projectIdeaDir = Paths.get(string, new String[0]);
        Path file = projectIdeaDir.resolve("intellij.yaml");
        if (!file.toFile().exists()) {
            file = projectIdeaDir.resolve("intellij.yml");
        }
        return file;
    }

    public static final /* synthetic */ Path access$findConfigurationFile(Project project) {
        return ConfigurationFileManagerKt.findConfigurationFile(project);
    }
}

