/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import javax.swing.text.Segment;

public class KeywordMap {
    private boolean ignoreCase;
    private Keyword[] literalMap;
    private Keyword[] parenMap;
    private static int MAP_LENGTH = 52;

    public KeywordMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.literalMap = new Keyword[MAP_LENGTH];
        this.parenMap = new Keyword[MAP_LENGTH];
    }

    public byte lookup(Segment text, int offset, int length, boolean paren) {
        if (length == 0) {
            return 0;
        }
        int key = this.getSegmentMapKey(text, offset, length);
        Keyword k = paren ? this.parenMap[key] : this.literalMap[key];
        while (k != null) {
            if (length == k.keyword.length && KeywordMap.regionMatches(this.ignoreCase, text, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public void add(String keyword, byte id, boolean paren) {
        int key = this.getStringMapKey(keyword);
        Keyword[] map = paren ? this.parenMap : this.literalMap;
        map[key] = new Keyword(keyword.toCharArray(), id, map[key]);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    protected int getStringMapKey(String s) {
        return (Character.toUpperCase(s.charAt(0)) + Character.toUpperCase(s.charAt(s.length() - 1))) % MAP_LENGTH;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % MAP_LENGTH;
    }

    private static class Keyword {
        public final char[] keyword;
        public final byte id;
        public final Keyword next;

        public Keyword(char[] keyword, byte id, Keyword next) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
        }
    }
}

