/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.statediagram.StateDiagram;

public class CommandCreatePackageState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreatePackageState() {
        super(CommandCreatePackageState.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreatePackageState.class.getName(), RegexLeaf.start(), new RegexLeaf("state"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]")), new RegexConcat(new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreatePackageState.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LINECOLOR", "##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?")), new RegexLeaf("(?:[%s]*\\{|[%s]+begin)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private String getNotNull(RegexResult arg, String v1, String v2) {
        if (arg.get(v1, 0) == null) {
            return arg.get(v2, 0);
        }
        return arg.get(v1, 0);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg) {
        String urlString;
        IGroup currentPackage = diagram.getCurrentGroup();
        String idShort = this.getNotNull(arg, "CODE1", "CODE2");
        Code code = diagram.buildCode(idShort);
        String display = this.getNotNull(arg, "DISPLAY1", "DISPLAY2");
        if (display == null) {
            display = code.getName();
        }
        Ident idNewLong = diagram.buildLeafIdentSpecial(idShort);
        diagram.gotoGroup(idNewLong, code, Display.getWithNewlines(display), GroupType.STATE, currentPackage, NamespaceStrategy.SINGLE);
        IGroup p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        Colors colors = CommandCreatePackageState.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        HtmlColor lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1));
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (arg.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(arg.get("LINECOLOR", 0));
        }
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

