/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Volume;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import tech.units.indriya.unit.Units;

public abstract class AbstractUnitConversionRule
extends Rule {
    protected static final Unit<Mass> POUND = Units.KILOGRAM.multiply(0.45359237);
    protected static final Unit<Mass> OUNCE = POUND.divide(12.0);
    protected static final Unit<Length> FEET = Units.METRE.multiply(0.3048);
    protected static final Unit<Length> YARD = FEET.multiply(3.0);
    protected static final Unit<Length> INCH = FEET.divide(12.0);
    protected static final Unit<Length> MILE = FEET.multiply(5280.0);
    protected static final Unit<Volume> US_QUART = Units.LITRE.multiply(0.946352946);
    protected static final Unit<Volume> US_GALLON = US_QUART.multiply(4.0);
    protected static final Unit<Volume> US_PINT = US_QUART.divide(2.0);
    protected static final Unit<Volume> US_CUP = US_QUART.divide(4.0);
    protected static final Unit<Volume> US_FL_OUNCE = US_QUART.divide(32.0);
    protected static final Unit<Volume> IMP_PINT = Units.LITRE.multiply(0.5682612532);
    protected static final Unit<Volume> IMP_QUART = IMP_PINT.multiply(2.0);
    protected static final Unit<Volume> IMP_GALLON = IMP_QUART.multiply(4.0);
    protected static final Unit<Volume> IMP_FL_OUNCE = IMP_PINT.divide(20.0);
    protected static final Unit<Temperature> FAHRENHEIT = Units.CELSIUS.multiply(0.5555555555555556).shift(-32.0);
    protected static final String NUMBER_REGEX = "(-?[0-9]{1,32}[0-9,.]{0,32})";
    protected final Pattern numberRangePart = Pattern.compile("\\b(-?[0-9]{1,32}[0-9,.]{0,32})$");
    private static final double DELTA = 0.01;
    private static final double ROUNDING_DELTA = 0.05;
    private static final int MAX_SUGGESTIONS = 5;
    private static final int WHITESPACE_LIMIT = 5;
    protected Map<Pattern, Unit> unitPatterns = new HashMap<Pattern, Unit>();
    protected Map<Pattern, Map.Entry<Unit, Function<MatchResult, Double>>> specialPatterns = new HashMap<Pattern, Map.Entry<Unit, Function<MatchResult, Double>>>();
    protected Map<Unit, List<String>> unitSymbols = new HashMap<Unit, List<String>>();
    protected List<Pattern> convertedPatterns = new ArrayList<Pattern>();
    protected final List<Unit> metricUnits = new ArrayList<Unit>();

    private URL buildURLForExplanation(String original) {
        try {
            String query = URLEncoder.encode("convert " + original + " to metric", "utf-8");
            return new URL("http://www.wolframalpha.com/input/?i=" + query);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected NumberFormat getNumberFormat() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df;
    }

    protected String getMessage(Message message) {
        switch (message) {
            case CHECK: {
                return "This conversion doesn't seem right. Do you want to correct it automatically?";
            }
            case SUGGESTION: {
                return "Writing for an international audience? Consider adding the metric equivalent.";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "This conversion doesn't seem right, unable to recognize the used unit.";
            }
            case UNIT_MISMATCH: {
                return "These units don't seem to be compatible.";
            }
        }
        throw new RuntimeException("Unknown message type: " + (Object)((Object)message));
    }

    protected String getShortMessage(Message message) {
        switch (message) {
            case CHECK: {
                return "Incorrect conversion. Correct it?";
            }
            case SUGGESTION: {
                return "Add metric equivalent?";
            }
            case CHECK_UNKNOWN_UNIT: {
                return "Unknown unit used in conversion.";
            }
            case UNIT_MISMATCH: {
                return "Units incompatible.";
            }
        }
        throw new RuntimeException("Unknown message type: " + (Object)((Object)message));
    }

    protected String getSuggestion(String original, String converted) {
        return original + " (" + converted + ")";
    }

    protected String formatRounded(String s) {
        return "ca. " + s;
    }

    protected void addUnit(String pattern, Unit base, String symbol, double factor, boolean metric) {
        Unit unit = base.multiply(factor);
        this.unitPatterns.put(Pattern.compile("\\b(-?[0-9]{1,32}[0-9,.]{0,32})\\s{0,5}" + pattern + "\\b"), unit);
        this.unitSymbols.putIfAbsent(unit, new ArrayList());
        this.unitSymbols.get(unit).add(symbol);
        if (metric && !this.metricUnits.contains(unit)) {
            this.metricUnits.add(unit);
        }
    }

    protected AbstractUnitConversionRule(ResourceBundle messages) {
        this.setCategory(Categories.SEMANTICS.getCategory(messages));
        this.addUnit("kg", (Unit)Units.KILOGRAM, "kg", 1.0, true);
        this.addUnit("g", (Unit)Units.KILOGRAM, "g", 0.001, true);
        this.addUnit("t", (Unit)Units.KILOGRAM, "t", 1000.0, true);
        this.addUnit("lb", POUND, "lb", 1.0, false);
        this.addUnit("oz", OUNCE, "oz", 1.0, false);
        this.addUnit("mi", MILE, "mi", 1.0, false);
        this.addUnit("yd", YARD, "yd", 1.0, false);
        this.addUnit("(?:ft|\u2032|')", FEET, "ft", 1.0, false);
        this.addUnit("(?:inch|\u2033)", INCH, "inch", 1.0, false);
        this.addUnit("(?:km/h|kmh)", Units.KILOMETRE_PER_HOUR, "km/h", 1.0, true);
        this.addUnit("(?:mph)", MILE.divide(Units.HOUR), "mph", 1.0, false);
        this.addUnit("km", Units.METRE, "km", 1000.0, true);
        this.addUnit("m", Units.METRE, "m", 1.0, true);
        this.addUnit("dm", Units.METRE, "dm", 0.1, false);
        this.addUnit("cm", Units.METRE, "cm", 0.01, true);
        this.addUnit("mm", Units.METRE, "mm", 0.001, true);
        this.addUnit("\u00b5m", Units.METRE, "\u00b5m", 1.0E-6, true);
        this.addUnit("nm", Units.METRE, "nm", 1.0E-9, true);
        this.addUnit("m(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "m\u00b2", 1.0, true);
        this.addUnit("ha", Units.SQUARE_METRE, "ha", 10000.0, true);
        this.addUnit("a", Units.SQUARE_METRE, "a", 100.0, true);
        this.addUnit("km(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "km\u00b2", 1000000.0, true);
        this.addUnit("dm(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "dm\u00b2", 0.01, false);
        this.addUnit("cm(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "cm\u00b2", 1.0E-4, true);
        this.addUnit("mm(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "mm\u00b2", 1.0E-6, true);
        this.addUnit("\u00b5m(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "\u00b5m\u00b2", 1.0E-12, true);
        this.addUnit("nm(?:\\^2|2|\u00b2)", Units.SQUARE_METRE, "nm\u00b2", 1.0E-18, true);
        this.addUnit("(?:sq|square) (?:in(?:ch)?|inches)", INCH.multiply(INCH), "sq in", 1.0, false);
        this.addUnit("(?:inches|in|inch) (?:\\^2|2|\u00b2)", INCH.multiply(INCH), "in\u00b2", 1.0, false);
        this.addUnit("(?:sq|square) (?:ft|feet|foot)", FEET.multiply(FEET), "sq ft", 1.0, false);
        this.addUnit("sf", FEET.multiply(FEET), "sf", 1.0, false);
        this.addUnit("ft(?:\\^2|2|\u00b2)", FEET.multiply(FEET), "ft\u00b2", 1.0, false);
        this.addUnit("(?:sq|square) (?:yds?|yards?)", YARD.multiply(YARD), "sq yd", 1.0, false);
        this.addUnit("(?:yards?|yds?)(?:\\^2|2|\u00b2)", YARD.multiply(YARD), "yd\u00b2", 1.0, false);
        this.addUnit("m(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "m\u00b3", 1.0, true);
        this.addUnit("km(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "km\u00b3", 1.0E9, true);
        this.addUnit("dm(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "dm\u00b3", 0.001, false);
        this.addUnit("cm(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "cm\u00b3", 1.0E-6, true);
        this.addUnit("mm(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "mm\u00b3", 1.0E-9, true);
        this.addUnit("\u00b5m(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "\u00b5m\u00b3", 1.0E-18, true);
        this.addUnit("nm(?:\\^3|3|\u00b3)", Units.CUBIC_METRE, "nm\u00b3", 1.0E-27, true);
        this.addUnit("(?:cubic|cu) (?:feet|ft|foot)", FEET.multiply(FEET).multiply(FEET), "cubic feet", 1.0, false);
        this.addUnit("(?:feet|ft|foot)(?:\\^3|3|\u00b3)", FEET.multiply(FEET).multiply(FEET), "ft\u00b3", 1.0, false);
        this.addUnit("(?:cubic|cu) (?:inch|in|inches)", INCH.multiply(INCH).multiply(INCH), "cubic inch", 1.0, false);
        this.addUnit("(?:inch|in)(?:\\^3|3|\u00b3)", INCH.multiply(INCH).multiply(INCH), "inch\u00b3", 1.0, false);
        this.addUnit("(?:cubic|cu) (?:yards?|yds?)", YARD.multiply(YARD).multiply(YARD), "cubic yard", 1.0, false);
        this.addUnit("(?:yard|yd)(?:\\^3|3|\u00b3)", YARD.multiply(YARD).multiply(YARD), "yard\u00b3", 1.0, false);
        this.addUnit("l", Units.LITRE, "l", 1.0, true);
        this.addUnit("ml", Units.LITRE, "ml", 0.001, true);
        this.addUnit("\u00b0F", FAHRENHEIT, "\u00b0F", 1.0, false);
        this.addUnit("\u00b0C", (Unit)Units.CELSIUS, "\u00b0C", 1.0, true);
        this.convertedPatterns.add(Pattern.compile("\\s*\\((?:ca. )?(-?[0-9]{1,32}[0-9,.]{0,32})\\s*([^)]+)\\s*\\)"));
        Function<MatchResult, Double> parseFeetAndInch = match -> {
            double inch;
            double feet;
            try {
                feet = this.getNumberFormat().parse(match.group(1)).doubleValue();
            }
            catch (ParseException e) {
                return null;
            }
            try {
                inch = this.getNumberFormat().parse(match.group(2)).doubleValue();
            }
            catch (ParseException e) {
                inch = 0.0;
            }
            return feet + inch / 12.0;
        };
        AbstractMap.SimpleImmutableEntry<Unit<Length>, Function<MatchResult, Double>> feetAndInchEntry = new AbstractMap.SimpleImmutableEntry<Unit<Length>, Function<MatchResult, Double>>(FEET, parseFeetAndInch);
        this.specialPatterns.put(Pattern.compile("(?:(?<=[^\u00ba\u00b0\\d]))\\s(\\d+)(?:ft|\u2032|')\\s*(\\d+)\\s*(?:in|\"|\u2033)?"), feetAndInchEntry);
        this.specialPatterns.put(Pattern.compile("(?:(?<=[^\u00ba\u00b0\\d\\s]))(\\d+)(?:ft|\u2032|')\\s*(\\d+)\\s*(?:in|\"|\u2033)?"), feetAndInchEntry);
    }

    @Nullable
    protected List<Map.Entry<Unit, Double>> getMetricEquivalent(double value, @NotNull Unit unit) {
        LinkedList<Map.Entry<Unit, Double>> conversions = new LinkedList<Map.Entry<Unit, Double>>();
        for (Unit metric : this.metricUnits) {
            if (unit.equals(metric)) {
                return null;
            }
            if (!unit.isCompatible(metric)) continue;
            Double converted = unit.getConverterTo(metric).convert(value);
            conversions.add(new AbstractMap.SimpleImmutableEntry<Unit, Double>(metric, converted));
        }
        this.sortByNaturalness(conversions);
        if (conversions.isEmpty()) {
            return null;
        }
        return conversions;
    }

    @Nullable
    protected List<String> formatMeasurement(double value, @NotNull Unit unit) {
        List<Map.Entry<Unit, Double>> equivalents = this.getMetricEquivalent(value, unit);
        if (equivalents == null) {
            return null;
        }
        List<String> formatted = this.getFormattedConversions(equivalents);
        if (formatted.isEmpty()) {
            return null;
        }
        return formatted;
    }

    @NotNull
    private List<String> getFormattedConversions(List<Map.Entry<Unit, Double>> conversions) {
        ArrayList<String> formatted = new ArrayList<String>();
        block0: for (Map.Entry<Unit, Double> equivalent : conversions) {
            Unit metric = equivalent.getKey();
            double converted = equivalent.getValue();
            long rounded = Math.round(converted);
            for (String symbol : (List)this.unitSymbols.getOrDefault(metric, new ArrayList())) {
                String formattedNumber;
                String formattedStr;
                String formattedStr2;
                if (formatted.size() > 5) continue block0;
                if (Math.abs(converted - (double)rounded) / Math.abs(converted) < 0.05 && rounded != 0L && !formatted.contains(formattedStr2 = this.formatRounded(this.getNumberFormat().format(rounded) + " " + symbol))) {
                    formatted.add(formattedStr2);
                }
                if (formatted.contains(formattedStr = (formattedNumber = this.getNumberFormat().format(converted)) + " " + symbol) || formattedNumber.equals("0")) continue;
                formatted.add(formattedStr);
            }
        }
        return formatted;
    }

    private void sortByNaturalness(List<Map.Entry<Unit, Double>> conversions) {
        conversions.sort((a, b) -> {
            DoubleUnaryOperator naturalness = number -> {
                double abs = Math.abs(number);
                if (abs < 1.0) {
                    return 1.0 / (abs * abs * 2.0);
                }
                if (abs < 100.0) {
                    return abs - 50.0;
                }
                return abs * abs;
            };
            double scoreA = naturalness.applyAsDouble((Double)a.getValue());
            double scoreB = naturalness.applyAsDouble((Double)b.getValue());
            return Double.compare(scoreA, scoreB);
        });
    }

    private void matchUnits(AnalyzedSentence sentence, List<RuleMatch> matches, List<Map.Entry<Integer, Integer>> ignoreRanges, boolean isMetric) {
        for (Pattern unitPattern : this.unitPatterns.keySet()) {
            if (this.metricUnits.contains(this.unitPatterns.get(unitPattern)) != isMetric) continue;
            Matcher unitMatcher = unitPattern.matcher(sentence.getText());
            while (unitMatcher.find()) {
                boolean ignore = false;
                for (Map.Entry<Integer, Integer> range : ignoreRanges) {
                    if (unitMatcher.start() < range.getKey() || unitMatcher.end() > range.getValue()) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                this.tryConversion(sentence, matches, unitPattern, null, null, unitMatcher, ignoreRanges);
            }
        }
    }

    protected boolean detectNumberRange(AnalyzedSentence sentence, Matcher matcher) {
        boolean hyphenInNumber = matcher.group(1).startsWith("-");
        if (!hyphenInNumber) {
            return false;
        }
        String textBefore = sentence.getText().substring(0, matcher.start());
        boolean endsWithNumberRangePart = this.numberRangePart.matcher(textBefore).find();
        return endsWithNumberRangePart;
    }

    private void tryConversion(AnalyzedSentence sentence, List<RuleMatch> matches, Pattern unitPattern, Double customValue, Unit customUnit, Matcher unitMatcher, List<Map.Entry<Integer, Integer>> ignoreRanges) {
        double value;
        AbstractMap.SimpleImmutableEntry<Integer, Integer> range = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(unitMatcher.start(), unitMatcher.end());
        ignoreRanges.add(range);
        String convertedInText = null;
        int convertedOffset = unitMatcher.end();
        Matcher convertedMatcher = null;
        for (Pattern convertedPattern : this.convertedPatterns) {
            convertedMatcher = convertedPattern.matcher(sentence.getText().substring(convertedOffset));
            if (!convertedMatcher.find() || convertedMatcher.start() != 0) continue;
            convertedInText = convertedMatcher.group(0);
            break;
        }
        Unit unit = this.unitPatterns.getOrDefault(unitPattern, customUnit);
        if (customValue == null) {
            try {
                String valueAsString = unitMatcher.group(1);
                if (this.detectNumberRange(sentence, unitMatcher)) {
                    valueAsString = valueAsString.substring(1);
                }
                value = this.getNumberFormat().parse(valueAsString).doubleValue();
            }
            catch (ParseException e) {
                return;
            }
        } else {
            value = customValue;
        }
        List<String> converted = this.formatMeasurement(value, unit);
        if (converted != null || convertedInText != null) {
            if (convertedInText == null) {
                RuleMatch match = new RuleMatch(this, sentence, unitMatcher.start(), unitMatcher.end(), this.getMessage(Message.SUGGESTION), this.getShortMessage(Message.SUGGESTION));
                List<String> suggestions = converted.stream().map(formatted -> this.getSuggestion(unitMatcher.group(0), (String)formatted)).collect(Collectors.toList());
                match.setSuggestedReplacements(suggestions);
                match.setUrl(this.buildURLForExplanation(unitMatcher.group(0)));
                matches.add(match);
            } else {
                AbstractMap.SimpleImmutableEntry<Integer, Integer> convertedRange = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(convertedMatcher.start(1) + convertedOffset, convertedMatcher.end(2) + convertedOffset);
                ignoreRanges.add(convertedRange);
                String finalConvertedInText = convertedInText.trim();
                String convertedTrimmed = finalConvertedInText.substring(1, finalConvertedInText.length() - 1);
                if (converted != null && converted.stream().anyMatch(s -> s.equals(convertedTrimmed))) {
                    return;
                }
                Optional<Pattern> convertedUnitPattern = this.unitPatterns.keySet().stream().filter(pattern -> pattern.matcher(finalConvertedInText).find()).findFirst();
                if (convertedUnitPattern.isPresent()) {
                    Double convertedValueInText;
                    Unit convertedUnit = this.unitPatterns.get(convertedUnitPattern.get());
                    try {
                        convertedValueInText = this.getNumberFormat().parse(convertedMatcher.group(1)).doubleValue();
                    }
                    catch (ParseException e) {
                        return;
                    }
                    if (converted == null) {
                        List<String> reverseConverted = null;
                        try {
                            double unitConverted = unit.getConverterTo(convertedUnit).convert(value);
                            double diff = Math.abs(unitConverted - convertedValueInText);
                            if (diff > 0.01) {
                                RuleMatch match = new RuleMatch(this, sentence, convertedMatcher.start(1) + convertedOffset, convertedMatcher.end(1) + convertedOffset, this.getMessage(Message.CHECK), this.getShortMessage(Message.CHECK));
                                match.setUrl(this.buildURLForExplanation(convertedTrimmed));
                                ArrayList<Map.Entry<Unit, Double>> numbers = new ArrayList<Map.Entry<Unit, Double>>();
                                numbers.add(new AbstractMap.SimpleImmutableEntry<Unit, Double>(convertedUnit, unitConverted));
                                reverseConverted = this.getFormattedConversions(numbers);
                                if (reverseConverted.stream().anyMatch(s -> s.equals(convertedTrimmed))) {
                                    return;
                                }
                                match.setSuggestedReplacements(reverseConverted);
                                matches.add(match);
                            }
                        }
                        catch (UnconvertibleException e) {
                            RuleMatch match = new RuleMatch(this, sentence, unitMatcher.start(), convertedMatcher.end() + convertedOffset, this.getMessage(Message.UNIT_MISMATCH), this.getShortMessage(Message.UNIT_MISMATCH));
                            if (reverseConverted != null) {
                                match.setSuggestedReplacements(reverseConverted);
                            }
                            match.setUrl(this.buildURLForExplanation(convertedTrimmed));
                            matches.add(match);
                        }
                    } else {
                        List<Map.Entry<Unit, Double>> metricEquivalents = this.getMetricEquivalent(value, unit);
                        if (metricEquivalents == null || metricEquivalents.isEmpty()) {
                            return;
                        }
                        Map.Entry<Unit, Double> metricEquivalent = metricEquivalents.get(0);
                        Unit metricUnit = metricEquivalent.getKey();
                        Double convertedValueComputed = metricEquivalent.getValue();
                        if (!convertedUnit.equals(metricUnit) || !(Math.abs(convertedValueInText - convertedValueComputed) < 0.01)) {
                            RuleMatch match = new RuleMatch(this, sentence, convertedMatcher.start(1) + convertedOffset, convertedMatcher.end(2) + convertedOffset, this.getMessage(Message.CHECK), this.getShortMessage(Message.CHECK));
                            match.setSuggestedReplacements(converted);
                            match.setUrl(this.buildURLForExplanation(unitMatcher.group(0)));
                            matches.add(match);
                        }
                    }
                } else if (converted != null) {
                    RuleMatch match = new RuleMatch(this, sentence, convertedMatcher.start(1) + convertedOffset, convertedMatcher.end(2) + convertedOffset, this.getMessage(Message.CHECK_UNKNOWN_UNIT), this.getShortMessage(Message.CHECK_UNKNOWN_UNIT));
                    match.setSuggestedReplacements(converted);
                    matches.add(match);
                }
            }
        }
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        LinkedList<Map.Entry<Integer, Integer>> ignoreRanges = new LinkedList<Map.Entry<Integer, Integer>>();
        for (Pattern specialPattern : this.specialPatterns.keySet()) {
            Matcher matcher = specialPattern.matcher(sentence.getText());
            while (matcher.find()) {
                MatchResult result = matcher.toMatchResult();
                Double value = this.specialPatterns.get(specialPattern).getValue().apply(result);
                Unit unit = this.specialPatterns.get(specialPattern).getKey();
                if (value == null) continue;
                boolean ignore = false;
                for (Map.Entry entry : ignoreRanges) {
                    if (matcher.start() < (Integer)entry.getKey() || matcher.end() > (Integer)entry.getValue()) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                this.tryConversion(sentence, matches, specialPattern, value, unit, matcher, ignoreRanges);
            }
        }
        this.matchUnits(sentence, matches, ignoreRanges, true);
        this.matchUnits(sentence, matches, ignoreRanges, false);
        HashMap<Integer, RuleMatch> matchesByStart = new HashMap<Integer, RuleMatch>();
        for (RuleMatch match : matches) {
            matchesByStart.compute(match.getFromPos(), (pos, other) -> other == null ? match : (match.getToPos() > other.getToPos() ? match : other));
        }
        return matchesByStart.values().toArray(new RuleMatch[0]);
    }

    protected static enum Message {
        SUGGESTION,
        CHECK,
        CHECK_UNKNOWN_UNIT,
        UNIT_MISMATCH;

    }
}

