/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.ConvertColumnToDynamic;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.gephi.ui.utils.IntervalBoundValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConvertColumnToDynamicUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    private static final String INTERVAL_START_PREFERENCE = "ConvertColumnToDynamicUI.intervalStart";
    private static final String INTERVAL_END_PREFERENCE = "ConvertColumnToDynamicUI.intervalEnd";
    private static final String REPLACE_COLUMN_PREFERENCE = "ConvertColumnToDynamicUI.replaceColumn";
    private static final String DEFAULT_INTERVAL_START = "-Infinity";
    private static final String DEFAULT_INTERVAL_END = "Infinity";
    private ConvertColumnToDynamic manipulator;
    private Table table;
    private DialogControls dialogControls;
    private ValidationPanel validationPanel;
    private JLabel descriptionLabel;
    private JLabel intervalEndLabel;
    private JTextField intervalEndText;
    private JLabel intervalStartLabel;
    private JTextField intervalStartText;
    private JCheckBox replaceColumnCheckbox;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public ConvertColumnToDynamicUI() {
        this.initComponents();
        this.intervalStartText.setText(NbPreferences.forModule(ConvertColumnToDynamicUI.class).get(INTERVAL_START_PREFERENCE, DEFAULT_INTERVAL_START));
        this.intervalEndText.setText(NbPreferences.forModule(ConvertColumnToDynamicUI.class).get(INTERVAL_END_PREFERENCE, DEFAULT_INTERVAL_END));
        this.replaceColumnCheckbox.setSelected(NbPreferences.forModule(ConvertColumnToDynamicUI.class).getBoolean(REPLACE_COLUMN_PREFERENCE, false));
    }

    private void buildValidationPanel() {
        this.validationPanel = new ValidationPanel();
        this.validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = this.validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        group.add((JTextComponent)this.intervalStartText, new Validator[]{new IntervalBoundValidator()});
        group.add((JTextComponent)this.intervalEndText, new Validator[]{new IntervalBoundValidator((JTextComponent)this.intervalStartText)});
        this.validationPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConvertColumnToDynamicUI.this.dialogControls.setOkButtonEnabled(!ConvertColumnToDynamicUI.this.validationPanel.isProblem());
            }
        });
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.table = table;
        this.dialogControls = dialogControls;
        this.manipulator = (ConvertColumnToDynamic)m;
        this.buildValidationPanel();
        this.descriptionLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.descriptionLabel.text", (Object)column.getTitle()));
        this.titleTextField.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.new.title", (Object)column.getTitle()));
        this.refreshTitleEnabledState();
    }

    public void unSetup() {
        String intervalStart = this.intervalStartText.getText();
        String intervalEnd = this.intervalEndText.getText();
        boolean replaceColumn = this.replaceColumnCheckbox.isSelected();
        NbPreferences.forModule(ConvertColumnToDynamicUI.class).put(INTERVAL_START_PREFERENCE, intervalStart);
        NbPreferences.forModule(ConvertColumnToDynamicUI.class).put(INTERVAL_END_PREFERENCE, intervalEnd);
        NbPreferences.forModule(ConvertColumnToDynamicUI.class).putBoolean(REPLACE_COLUMN_PREFERENCE, replaceColumn);
        if (!this.validationPanel.isProblem()) {
            this.manipulator.setTitle(this.titleTextField.getText());
            this.manipulator.setReplaceColumn(replaceColumn);
            this.manipulator.setLow(AttributeUtils.parseDateTimeOrTimestamp((String)intervalStart));
            this.manipulator.setHigh(AttributeUtils.parseDateTimeOrTimestamp((String)intervalEnd));
        }
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this.validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void refreshTitleEnabledState() {
        boolean enabled = !this.replaceColumnCheckbox.isSelected();
        this.titleTextField.setEnabled(enabled);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.replaceColumnCheckbox = new JCheckBox();
        this.intervalStartLabel = new JLabel();
        this.intervalStartText = new JTextField();
        this.intervalEndLabel = new JLabel();
        this.intervalEndText = new JTextField();
        this.titleLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.titleTextField.text"));
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(null);
        this.replaceColumnCheckbox.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.replaceColumnCheckbox.text"));
        this.replaceColumnCheckbox.setToolTipText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.replaceColumnCheckbox.toolTipText"));
        this.replaceColumnCheckbox.setHorizontalTextPosition(10);
        this.replaceColumnCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertColumnToDynamicUI.this.replaceColumnCheckboxActionPerformed(evt);
            }
        });
        this.intervalStartLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.intervalStartLabel.text"));
        this.intervalEndLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicUI.class, (String)"ConvertColumnToDynamicUI.intervalEndLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.replaceColumnCheckbox).addGap(16, 16, 16).addComponent(this.titleLabel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 190, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.intervalEndLabel, -1, -1, Short.MAX_VALUE).addComponent(this.intervalStartLabel, -1, 117, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intervalStartText).addComponent(this.intervalEndText)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intervalStartLabel).addComponent(this.intervalStartText, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intervalEndLabel).addComponent(this.intervalEndText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2).addComponent(this.replaceColumnCheckbox)).addGap(24, 24, 24)));
    }

    private void replaceColumnCheckboxActionPerformed(ActionEvent evt) {
        this.refreshTitleEnabledState();
    }
}

