/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.ProjectModule;

public class PHPProjectModule
extends ProjectModule {
    public static final String PHP_MODULE_TYPE_ID = "php.web";
    private IScriptProject fScriptProject;

    public PHPProjectModule(IProject project) {
        super(project);
        this.fScriptProject = DLTKCore.create((IProject)project);
    }

    protected IModuleResource[] getModuleResources(IPath path, IContainer container) throws CoreException {
        return this.internalGetModuleResources(path, container);
    }

    private IModuleResource[] internalGetModuleResources(IPath path, IContainer container) throws CoreException {
        IResource[] resources = null;
        if (container instanceof IProject) {
            IProjectFragment[] projectFragments;
            ArrayList<IResource> list = new ArrayList<IResource>();
            IProjectFragment[] iProjectFragmentArray = projectFragments = this.fScriptProject.getAllProjectFragments();
            int n = projectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment fragment = iProjectFragmentArray[n2];
                if (!fragment.isExternal()) {
                    list.addAll(Arrays.asList(((IContainer)fragment.getResource()).members()));
                }
                ++n2;
            }
            resources = list.toArray(new IResource[list.size()]);
        } else {
            resources = container.members();
        }
        if (resources != null) {
            int size = resources.length;
            ArrayList<Object> list = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                IResource resource = resources[i];
                if (resource != null && resource.exists()) {
                    String name = resource.getName();
                    if (resource instanceof IContainer) {
                        IContainer container2 = (IContainer)resource;
                        ModuleFolder mf = new ModuleFolder(container2, name, path);
                        mf.setMembers(this.internalGetModuleResources(path.append(name), container2));
                        list.add(mf);
                    } else if (resource instanceof IFile) {
                        list.add(new ModuleFile((IFile)resource, name, path));
                    }
                }
                ++i;
            }
            IModuleResource[] moduleResources = new IModuleResource[list.size()];
            list.toArray(moduleResources);
            return moduleResources;
        }
        return new IModuleResource[0];
    }
}

