/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.dstore.core.model.Client;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.ServerLogger;
import org.eclipse.dstore.core.server.ServerReceiver;
import org.eclipse.dstore.core.server.SystemServiceManager;
import org.eclipse.dstore.internal.core.server.ServerAttributes;
import org.eclipse.dstore.internal.core.server.ServerCommandHandler;
import org.eclipse.dstore.internal.core.server.ServerSSLProperties;
import org.eclipse.dstore.internal.core.server.ServerUpdateHandler;
import org.eclipse.dstore.internal.core.util.ExternalLoader;
import org.eclipse.dstore.internal.core.util.Sender;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;

public class ConnectionEstablisher {
    private ServerSocket _serverSocket;
    private boolean _continue;
    private ArrayList _receivers;
    private ServerCommandHandler _commandHandler;
    private ServerUpdateHandler _updateHandler;
    private ServerAttributes _serverAttributes = new ServerAttributes();
    private DataStore _dataStore;
    private int _maxConnections;
    private int _timeout;
    private String _msg;

    public ConnectionEstablisher() {
        String port = this._serverAttributes.getAttribute(5);
        this.setup(port, null, null);
    }

    public ConnectionEstablisher(String port) {
        this.setup(port, null, null);
    }

    public ConnectionEstablisher(String port, String timeout) {
        this.setup(port, timeout, null);
    }

    public ConnectionEstablisher(String port, String timeout, String ticket) {
        this.setup(port, timeout, ticket);
    }

    public ConnectionEstablisher(String port, int backlog, InetAddress bindAddr, String timeout, String ticket) {
        this.setup(port, backlog, bindAddr, timeout, ticket);
    }

    public void start() {
        this.run();
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public int getServerPort() {
        if (this._serverSocket != null) {
            return this._serverSocket.getLocalPort();
        }
        return -1;
    }

    public String getStatus() {
        return this._msg;
    }

    public void finished(ServerReceiver receiver) {
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher.finished()");
        }
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher - removing receiver");
        }
        this._receivers.remove(receiver);
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher - removing preference listener");
        }
        this._dataStore.removeDataStorePreferenceListener(receiver);
        this._continue = false;
        this._commandHandler.finish();
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher - finishing update handler");
        }
        this._updateHandler.finish();
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher - removing sender");
        }
        this._updateHandler.removeSenderWith(receiver.socket());
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "ConnectionEstablisher - finishing DataStore");
        }
        this._dataStore.finish();
        System.out.println("Server Finished");
        if (SystemServiceManager.getInstance().getSystemService() == null) {
            System.exit(0);
        }
    }

    private void waitForConnections() {
        while (this._continue) {
            try {
                Socket newSocket = this._serverSocket.accept();
                if (this._dataStore.usingSSL()) {
                    SSLSocket sslSocket = (SSLSocket)newSocket;
                    sslSocket.setUseClientMode(false);
                    sslSocket.setNeedClientAuth(false);
                    SSLSession session = sslSocket.getSession();
                    if (session == null) {
                        System.out.println("handshake failed");
                        sslSocket.close();
                        return;
                    }
                }
                this.doHandShake(newSocket);
                newSocket.setKeepAlive(true);
                ServerReceiver receiver = new ServerReceiver(newSocket, this);
                this._dataStore.addDataStorePreferenceListener(receiver);
                if (this._dataStore.getClient() != null) {
                    this._dataStore.getClient().setServerReceiver(receiver);
                }
                Sender sender = new Sender(newSocket, this._dataStore);
                this._receivers.add(receiver);
                this._updateHandler.addSender(sender);
                receiver.start();
                if (this._receivers.size() == 1) {
                    this._updateHandler.start();
                    this._commandHandler.start();
                }
                if (this._receivers.size() != this._maxConnections) continue;
                this._continue = false;
                this._serverSocket.close();
            }
            catch (IOException ioe) {
                System.err.println("Connection error");
                System.err.println("Server: error initializing socket: " + ioe);
                this._msg = ioe.toString();
                try {
                    this._serverSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this._continue = false;
            }
        }
    }

    private ServerSocket createSocket(String portStr, int backlog, InetAddress bindAddr) throws UnknownHostException {
        String[] range;
        ServerSocket serverSocket = null;
        SSLContext sslContext = null;
        int port = 0;
        if (this._dataStore.usingSSL()) {
            String keyStoreFileName = this._dataStore.getKeyStoreLocation();
            String keyStorePassword = this._dataStore.getKeyStorePassword();
            try {
                sslContext = DStoreSSLContext.getServerSSLContext(keyStoreFileName, keyStorePassword);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((range = portStr.split("-")).length == 2) {
            int lPort = 0;
            int hPort = 0;
            try {
                lPort = Integer.parseInt(range[0]);
                hPort = Integer.parseInt(range[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int i = lPort;
            while (i < hPort) {
                try {
                    if (this._dataStore.usingSSL() && sslContext != null) {
                        try {
                            serverSocket = sslContext.getServerSocketFactory().createServerSocket(i, backlog, bindAddr);
                        }
                        catch (BindException e) {
                            this._msg = "Error binding socket on port " + port + ": " + e.getMessage();
                            System.err.println(this._msg);
                            this._dataStore.trace(this._msg);
                        }
                        catch (Exception e) {}
                    } else {
                        try {
                            serverSocket = new ServerSocket(i, backlog, bindAddr);
                        }
                        catch (BindException e) {
                            this._msg = "Error binding socket on port " + port + ": " + e.getMessage();
                            System.err.println(this._msg);
                            this._dataStore.trace(this._msg);
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
                if (serverSocket != null && serverSocket.getLocalPort() > 0) {
                    return serverSocket;
                }
                ++i;
            }
            if (serverSocket == null) {
                this._msg = "Error binding socket on ports " + portStr;
                System.err.println(this._msg);
            }
        } else {
            port = Integer.parseInt(portStr);
            if (this._dataStore.usingSSL() && sslContext != null) {
                try {
                    serverSocket = sslContext.getServerSocketFactory().createServerSocket(port, backlog, bindAddr);
                }
                catch (BindException e) {
                    this._msg = "Error binding socket on port " + port + ": " + e.getMessage();
                    System.err.println(this._msg);
                    this._dataStore.trace(this._msg);
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
            } else {
                try {
                    serverSocket = new ServerSocket(port, backlog, bindAddr);
                }
                catch (BindException e) {
                    this._msg = "Error binding socket on port " + port + ": " + e.getMessage();
                    System.err.println(this._msg);
                    this._dataStore.trace(this._msg);
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
            }
        }
        return serverSocket;
    }

    private void setup(String portStr, String timeoutStr, String ticketStr) {
        this.setup(portStr, 50, null, timeoutStr, ticketStr);
    }

    private void setup(String portStr, int backlog, InetAddress bindAddr, String timeoutStr, String ticketStr) {
        this._maxConnections = 1;
        ArrayList<ExternalLoader> loaders = new ArrayList<ExternalLoader>();
        loaders.add(new ExternalLoader(this.getClass().getClassLoader(), "*"));
        this._commandHandler = new ServerCommandHandler(loaders);
        this._updateHandler = new ServerUpdateHandler();
        ServerSSLProperties sslProperties = new ServerSSLProperties();
        this._dataStore = new DataStore(this._serverAttributes, this._commandHandler, this._updateHandler, null);
        this._dataStore.setSSLProperties(sslProperties);
        DataElement ticket = this._dataStore.getTicket();
        ticket.setAttribute(2, ticketStr);
        this._updateHandler.setDataStore(this._dataStore);
        this._commandHandler.setDataStore(this._dataStore);
        if (SystemServiceManager.getInstance().getSystemService() == null) {
            Client client = new Client();
            this._dataStore.setClient(client);
            ServerLogger logger = new ServerLogger(this._dataStore.getUserPreferencesDirectory());
            client.setLogger(logger);
        }
        this._receivers = new ArrayList();
        this._continue = true;
        try {
            this._serverSocket = this.createSocket(portStr, backlog, bindAddr);
            if (this._serverSocket == null) {
                this._continue = false;
            } else {
                this._timeout = timeoutStr != null ? Integer.parseInt(timeoutStr) : 120000;
                if (this._timeout > 0) {
                    this._serverSocket.setSoTimeout(this._timeout);
                }
                System.err.println("Server Started Successfully");
                System.err.println(this._serverSocket.getLocalPort());
                this._msg = "Server Started Successfully";
                System.err.println("Server running on: " + ServerAttributes.getHostName());
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown host error:" + e.getMessage());
            this._msg = "Unknown host error";
            this._continue = false;
        }
        catch (BindException e) {
            System.err.println("Error binding socket:" + e.getMessage());
            this._msg = "Error binding socket";
            this._continue = false;
        }
        catch (IOException e) {
            System.err.println("General IO error creating socket:" + e.getMessage());
            this._msg = "General IO error creating socket";
            this._continue = false;
        }
        catch (SecurityException e) {
            System.err.println("Security error creating socket:" + e.getMessage());
            this._msg = "Security error creating socket";
            this._continue = false;
        }
    }

    private void run() {
        this.waitForConnections();
    }

    private void doHandShake(Socket socket) {
        try {
            BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
            PrintWriter writer = new PrintWriter(bwriter);
            String version = "DataStore.8.0.0";
            String preferenceVersion = System.getProperty("DSTORE_VERSION");
            if (preferenceVersion != null && preferenceVersion.length() > 0) {
                version = preferenceVersion;
            }
            writer.println(version);
            writer.flush();
        }
        catch (IOException e) {
            if (this._dataStore.getClient() != null) {
                this._dataStore.getClient().getLogger().logError(this.getClass().toString(), e.toString(), e);
            }
            System.out.println(e);
        }
    }
}

