/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources;

import java.util.function.Function;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class DebugSourcesViewComparator<T>
extends ViewerComparator {
    private Function<T, Comparable<?>> func;
    private int propertyIndex;
    private Direction direction = Direction.DESCENDING;

    public DebugSourcesViewComparator(Function<T, Comparable<?>> func) {
        this.func = func;
    }

    public DebugSourcesViewComparator() {
        this.propertyIndex = 0;
        this.direction = Direction.DESCENDING;
    }

    public int getDirection() {
        return this.direction == Direction.DESCENDING ? 1024 : 128;
    }

    public void setColumn(Function<T, Comparable<?>> column, int idx) {
        this.func = column;
        if (idx == this.propertyIndex) {
            this.direction = Direction.toggle(this.direction);
        } else {
            this.propertyIndex = idx;
            this.direction = Direction.DESCENDING;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Comparable<?> s1 = this.func.apply(e1);
        Comparable<?> s2 = this.func.apply(e2);
        int rc = s1.compareTo(s2);
        if (this.direction.equals((Object)Direction.DESCENDING)) {
            rc = -rc;
        }
        return rc;
    }

    private static enum Direction {
        ASCENDING,
        DESCENDING;


        public static Direction toggle(Direction direction) {
            return direction == ASCENDING ? DESCENDING : ASCENDING;
        }
    }
}

