/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartitioner;
import org.eclipse.ui.part.IPageBookViewPage;

public class IOConsole
extends TextConsole {
    private final IOConsolePartitioner partitioner;
    private InputStream inputStream;
    private final List<Closeable> openStreams = Collections.synchronizedList(new ArrayList());
    private final Charset charset;

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, boolean autoLifecycle) {
        this(name, consoleType, imageDescriptor, (String)null, autoLifecycle);
    }

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, String encoding, boolean autoLifecycle) {
        this(name, consoleType, imageDescriptor, encoding == null ? Charset.forName(WorkbenchEncoding.getWorkbenchDefaultEncoding()) : Charset.forName(encoding), autoLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, Charset charset, boolean autoLifecycle) {
        super(name, consoleType, imageDescriptor, autoLifecycle);
        this.charset = charset;
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.inputStream = new IOConsoleInputStream(this);
            this.openStreams.add(this.inputStream);
        }
        this.partitioner = new IOConsolePartitioner(this);
        IDocument document = this.getDocument();
        if (document != null) {
            this.partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        }
    }

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor) {
        this(name, consoleType, imageDescriptor, true);
    }

    public IOConsole(String name, ImageDescriptor imageDescriptor) {
        this(name, null, imageDescriptor);
    }

    @Override
    public IPageBookViewPage createPage(IConsoleView view) {
        return new IOConsolePage(this, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsoleOutputStream newOutputStream() {
        IOConsoleOutputStream outputStream = new IOConsoleOutputStream(this, this.charset);
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(outputStream);
        }
        return outputStream;
    }

    public IOConsoleInputStream getInputStream() {
        if (this.inputStream instanceof IOConsoleInputStream) {
            return (IOConsoleInputStream)this.inputStream;
        }
        return null;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public int getHighWaterMark() {
        return this.partitioner.getHighWaterMark();
    }

    public int getLowWaterMark() {
        return this.partitioner.getLowWaterMark();
    }

    public void setWaterMarks(int low, int high) {
        if (low >= 0 && low >= high) {
            throw new IllegalArgumentException("High water mark must be greater than low water mark");
        }
        this.partitioner.setWaterMarks(low, high);
    }

    private void checkFinished() {
        if (this.openStreams.isEmpty()) {
            this.partitioner.streamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleOutputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleInputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    @Override
    public void clearConsole() {
        this.partitioner.clearBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose() {
        IOConsole iOConsole = this;
        synchronized (iOConsole) {
            ArrayList<Closeable> list = new ArrayList<Closeable>(this.openStreams);
            for (Closeable closable : list) {
                try {
                    closable.close();
                }
                catch (IOException iOException) {}
            }
            this.inputStream = null;
        }
        IDocument document = this.partitioner.getDocument();
        this.partitioner.disconnect();
        document.setDocumentPartitioner(null);
        super.dispose();
    }

    public String getEncoding() {
        return this.charset.name();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isHandleControlCharacters() {
        return this.partitioner.isHandleControlCharacters();
    }

    public void setHandleControlCharacters(boolean handleControlCharacters) {
        this.partitioner.setHandleControlCharacters(handleControlCharacters);
    }

    public boolean isCarriageReturnAsControlCharacter() {
        return this.partitioner.isCarriageReturnAsControlCharacter();
    }

    public void setCarriageReturnAsControlCharacter(boolean carriageReturnAsControlCharacter) {
        this.partitioner.setCarriageReturnAsControlCharacter(carriageReturnAsControlCharacter);
    }
}

