/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.storage.file.FileBasedConfig;

class CachingRepository
extends FileRepository {
    private static final ThreadLocal<Map<File, CachedConfig>> CACHED_CONFIG = ThreadLocal.withInitial(() -> new HashMap());

    public CachingRepository(BaseRepositoryBuilder options) throws IOException {
        super(options);
    }

    public CachingRepository(String filename) throws IOException {
        super(filename);
    }

    public FileBasedConfig getConfig() {
        Map<File, CachedConfig> cache = CACHED_CONFIG.get();
        CachedConfig cfg = cache.get(this.getDirectory());
        if (cfg == null) {
            return super.getConfig();
        }
        if (cfg.config == null) {
            cfg.config = super.getConfig();
        }
        return cfg.config;
    }

    void cacheConfig(boolean doCache) {
        Map<File, CachedConfig> cache = CACHED_CONFIG.get();
        CachedConfig cfg = cache.get(this.getDirectory());
        if (cfg == null) {
            if (!doCache) {
                return;
            }
            cfg = new CachedConfig();
            cache.put(this.getDirectory(), cfg);
        }
        if (!doCache) {
            if (cfg.level > 0) {
                if (--cfg.level == 0) {
                    cache.remove(this.getDirectory());
                }
            } else {
                Activator.logWarning(MessageFormat.format(CoreText.CachingRepository_cacheLevelZero, this.getDirectory()), null);
            }
        } else if (doCache) {
            ++cfg.level;
        }
    }

    void clearConfigCache() {
        Map<File, CachedConfig> cache = CACHED_CONFIG.get();
        cache.remove(this.getDirectory());
    }

    public void close() {
        this.clearConfigCache();
        super.close();
    }

    private static class CachedConfig {
        int level;
        FileBasedConfig config;

        private CachedConfig() {
        }
    }
}

