/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class MultisetCountTester<E>
extends AbstractMultisetTester<E> {
    public void testCount_0() {
        MultisetCountTester.assertEquals((String)"multiset.count(missing) didn't return 0", (int)0, (int)this.getMultiset().count(this.e3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCount_1() {
        MultisetCountTester.assertEquals((String)"multiset.count(present) didn't return 1", (int)1, (int)this.getMultiset().count(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCount_3() {
        this.initThreeCopies();
        MultisetCountTester.assertEquals((String)"multiset.count(thriceContained) didn't return 3", (int)3, (int)this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testCount_nullAbsent() {
        MultisetCountTester.assertEquals((String)"multiset.count(null) didn't return 0", (int)0, (int)this.getMultiset().count(null));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testCount_null_forbidden() {
        try {
            this.getMultiset().count(null);
            MultisetCountTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testCount_nullPresent() {
        this.initCollectionWithNullElement();
        MultisetCountTester.assertEquals((int)1, (int)this.getMultiset().count(null));
    }

    public void testCount_wrongType() {
        MultisetCountTester.assertEquals((String)"multiset.count(wrongType) didn't return 0", (int)0, (int)this.getMultiset().count((Object)WrongType.VALUE));
    }

    @GwtIncompatible
    public static List<Method> getCountDuplicateInitializingMethods() {
        return Arrays.asList(Helpers.getMethod(MultisetCountTester.class, "testCount_3"));
    }
}

