/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.EqualsIncompatibleType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.function.Predicate;

@BugPattern(name="PredicateIncompatibleType", category=BugPattern.Category.JDK, summary="Using ::equals or ::isInstance as an incompatible Predicate; the predicate will always return false", severity=BugPattern.SeverityLevel.ERROR)
public class PredicateIncompatibleType
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher {
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Type predicateType = PredicateIncompatibleType.predicateType(ASTHelpers.getType((Tree)tree), state);
        if (predicateType == null) {
            return Description.NO_MATCH;
        }
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        if (tree.getName().contentEquals("equals") && !EqualsIncompatibleType.compatibilityOfTypes(receiverType, predicateType, state).compatible()) {
            return this.buildMessage(receiverType, predicateType, tree);
        }
        if (tree.getName().contentEquals("isInstance") && ASTHelpers.isSameType((Type)receiverType, (Type)state.getSymtab().classType, (VisitorState)state) && !receiverType.getTypeArguments().isEmpty()) {
            Type argumentType = receiverType.getTypeArguments().get(0);
            Type upperBound = ASTHelpers.getUpperBound((Type)predicateType, (Types)state.getTypes());
            if (!EqualsIncompatibleType.compatibilityOfTypes(upperBound, argumentType, state).compatible()) {
                return this.buildMessage(upperBound, argumentType, tree);
            }
        }
        return Description.NO_MATCH;
    }

    private static Type predicateType(Type type, VisitorState state) {
        Symbol predicate = state.getSymbolFromString(Predicate.class.getName());
        if (predicate == null) {
            return null;
        }
        Type asPredicate = state.getTypes().asSuper(type, predicate);
        if (asPredicate == null) {
            return null;
        }
        return (Type)Iterables.getOnlyElement(asPredicate.getTypeArguments(), null);
    }

    private Description buildMessage(Type type1, Type type2, MemberReferenceTree tree) {
        return this.buildDescription(tree).setMessage(String.format("Predicate will always evaluate to false because types %s and %s are incompatible", Signatures.prettyType((Type)type1), Signatures.prettyType((Type)type2))).build();
    }
}

