# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.reader_algorithm import ReaderAlgorithm


class SimpleReader(ReaderAlgorithm):
    """
    SimpleReader - Superclass for algorithms that are not time or
    parallel aware
    
    Superclass: ReaderAlgorithm
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSimpleReader, obj, update, **traits)
    
    def _get_current_file_name(self):
        return self._vtk_obj.GetCurrentFileName()
    current_file_name = traits.Property(_get_current_file_name, desc=\
        """
        Returns the filename that was last loaded by the reader. This is
        set internally in read_mesh()
        """
    )

    def get_file_name(self, *args):
        """
        V.get_file_name(int) -> string
        C++: const char *GetFileName(int i)
        Returns a particular filename stored by the reader.
        """
        ret = self._wrap_call(self._vtk_obj.GetFileName, *args)
        return ret

    def _get_number_of_file_names(self):
        return self._vtk_obj.GetNumberOfFileNames()
    number_of_file_names = traits.Property(_get_number_of_file_names, desc=\
        """
        Returns the number of filenames stored by the reader.
        """
    )

    def get_time_value(self, *args):
        """
        V.get_time_value(string) -> float
        C++: virtual double GetTimeValue(const std::string &fname)
        A subclass can override this method to provide an actual time
        value for a given file (this method is called for each filename
        stored by the reader). If time values is not available, the
        subclass does not have to override. This will return
        Math::NaN() if no time value is present in the file.
        """
        ret = self._wrap_call(self._vtk_obj.GetTimeValue, *args)
        return ret

    def add_file_name(self, *args):
        """
        V.add_file_name(string)
        C++: void AddFileName(const char *fname)
        Add a filename to be read. Since this superclass handles file
        series to support time, multiple filenames can be added. Note
        that the time values are either integers growing sequentially, or
        are obtained from individual files as supported by the subclass.
        """
        ret = self._wrap_call(self._vtk_obj.AddFileName, *args)
        return ret

    def clear_file_names(self):
        """
        V.clear_file_names()
        C++: void ClearFileNames()
        Removes all filenames stored by the reader.
        """
        ret = self._vtk_obj.ClearFileNames()
        return ret
        

    def read_arrays_simple(self, *args):
        """
        V.read_arrays_simple(string, DataObject) -> int
        C++: virtual int ReadArraysSimple(const std::string &fname,
            DataObject *output)
        A method that needs to be override by the subclass to provide
        data arrays. Note that the filename is passed to this method and
        should be used by the subclass. The subclass directly adds data
        arrays to the provided data object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadArraysSimple, *my_args)
        return ret

    def read_mesh_simple(self, *args):
        """
        V.read_mesh_simple(string, DataObject) -> int
        C++: virtual int ReadMeshSimple(const std::string &fname,
            DataObject *output)
        A method that needs to be override by the subclass to provide the
        mesh (topology). Note that the filename is passed to this method
        and should be used by the subclass. The subclass directly adds
        the structure/topology to the provided data object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadMeshSimple, *my_args)
        return ret

    def read_meta_data_simple(self, *args):
        """
        V.read_meta_data_simple(string, Information) -> int
        C++: virtual int ReadMetaDataSimple(const std::string &,
            Information *)
        A subclass can override this method to provide meta data specific
        to a particular file. In order for this method to be called,
        has_temporal_meta_data has to be set to true.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadMetaDataSimple, *my_args)
        return ret

    def read_points_simple(self, *args):
        """
        V.read_points_simple(string, DataObject) -> int
        C++: virtual int ReadPointsSimple(const std::string &fname,
            DataObject *output)
        A method that needs to be override by the subclass to provide the
        point coordinates. Note that the filename is passed to this
        method and should be used by the subclass. The subclass directly
        adds the coordinates to the provided data object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadPointsSimple, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SimpleReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SimpleReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit SimpleReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SimpleReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

