/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Blob;
import java.io.IOException;
import java.io.InputStream;

class BlobR
extends InputStream {
    private Blob blob;
    private int pos;

    BlobR(Blob blob) {
        this.blob = blob;
        this.pos = 0;
    }

    @Override
    public int available() throws IOException {
        int n = this.blob.size - this.pos;
        return n < 0 ? 0 : n;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.blob.close();
        this.blob = null;
        this.pos = 0;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = (long)this.pos + l;
        if (l2 < 0L) {
            l2 = 0L;
            this.pos = 0;
        } else if (l2 > (long)this.blob.size) {
            l2 = this.blob.size;
            this.pos = this.blob.size;
        } else {
            this.pos = (int)l2;
        }
        return l2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.blob.read(byArray, 0, this.pos, byArray.length);
        if (n > 0) {
            this.pos += n;
            return byArray[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.blob.read(byArray, 0, this.pos, byArray.length);
        if (n > 0) {
            this.pos += n;
            return n;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.blob.read(byArray, n, this.pos, n2);
        if (n3 > 0) {
            this.pos += n3;
            return n3;
        }
        return -1;
    }
}

