/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.SqlResult;
import com.mysql.cj.api.xdevapi.SqlStatement;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.x.protobuf.MysqlxDatatypes;
import com.mysql.cj.xdevapi.ExprUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class SqlStatementImpl
implements SqlStatement {
    private MysqlxSession mysqlxSession;
    private String sql;
    private List<MysqlxDatatypes.Any> args = new ArrayList<MysqlxDatatypes.Any>();

    public SqlStatementImpl(MysqlxSession mysqlxSession, String sql) {
        this.mysqlxSession = mysqlxSession;
        this.sql = sql;
    }

    @Override
    public SqlResult execute() {
        return this.mysqlxSession.executeSql(this.sql, this.args);
    }

    @Override
    public CompletableFuture<SqlResult> executeAsync() {
        return this.mysqlxSession.asyncExecuteSql(this.sql, this.args);
    }

    @Override
    public SqlStatement clearBindings() {
        this.args.clear();
        return this;
    }

    @Override
    public SqlStatement bind(List<Object> values) {
        values.stream().map(ExprUtil::argObjectToScalarAny).forEach(a -> this.args.add((MysqlxDatatypes.Any)a));
        return this;
    }

    @Override
    public SqlStatement bind(Map<String, Object> values) {
        throw new FeatureNotAvailableException("Cannot bind named parameters for SQL statements");
    }
}

