/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PHPRunToLineBreakpoint
extends PHPLineBreakpoint {
    private IFile fSourceFile;

    public PHPRunToLineBreakpoint(final IFile resource, final int lineNumber) throws DebugException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PHPRunToLineBreakpoint.this.fSourceFile = resource;
                IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)PHPRunToLineBreakpoint.this.getModelIdentifier());
                PHPRunToLineBreakpoint.this.setMarker(marker);
                PHPRunToLineBreakpoint.this.setRegistered(false);
                PHPRunToLineBreakpoint.this.setPersisted(false);
            }
        };
        this.run(this.getMarkerRule((IResource)resource), runnable);
    }

    @Override
    protected void createRuntimeBreakpoint(IMarker marker) throws CoreException {
        IFile file = this.getSourceFile();
        IPath path = file.getFullPath();
        String fileName = path.lastSegment();
        Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
        this.fBreakpoint = new Breakpoint(fileName, lineNumber);
        this.fBreakpoint.setLifeTime(1);
    }

    public boolean isRunToLineBreakpoint() {
        return true;
    }

    public IFile getSourceFile() {
        return this.fSourceFile;
    }
}

