/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;

public class ContextContainerTools {
    public static <C extends JaxbContextNode, R> void synchronizeWithResourceModel(Adapter<C, R> adapter) {
        ContextContainerTools.sync(adapter, true);
    }

    public static <C extends JaxbContextNode, R> void update(Adapter<C, R> adapter) {
        ContextContainerTools.sync(adapter, false);
    }

    protected static <C extends JaxbContextNode, R> void sync(Adapter<C, R> adapter, boolean sync) {
        HashSet contextElements = CollectionTools.hashSet(adapter.getContextElements());
        ArrayList<JaxbContextNode> contextElementsToSync = new ArrayList<JaxbContextNode>(contextElements.size());
        int resourceIndex = 0;
        for (R resourceElement : adapter.getResourceElements()) {
            boolean match = false;
            Iterator stream = contextElements.iterator();
            while (stream.hasNext()) {
                JaxbContextNode contextElement = (JaxbContextNode)stream.next();
                if (!ObjectTools.equals(adapter.getResourceElement(contextElement), resourceElement)) continue;
                adapter.moveContextElement(resourceIndex, contextElement);
                stream.remove();
                contextElementsToSync.add(contextElement);
                match = true;
                break;
            }
            if (!match) {
                adapter.addContextElement(resourceIndex, resourceElement);
            }
            ++resourceIndex;
        }
        for (JaxbContextNode contextElement : contextElements) {
            adapter.removeContextElement(contextElement);
        }
        for (JaxbContextNode contextElement : contextElementsToSync) {
            if (sync) {
                contextElement.synchronizeWithResourceModel();
                continue;
            }
            contextElement.update();
        }
    }

    private ContextContainerTools() {
        throw new UnsupportedOperationException();
    }

    public static interface Adapter<C extends JaxbContextNode, R> {
        public Iterable<C> getContextElements();

        public Iterable<R> getResourceElements();

        public R getResourceElement(C var1);

        public void moveContextElement(int var1, C var2);

        public void addContextElement(int var1, R var2);

        public void removeContextElement(C var1);
    }
}

