/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaMainTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public abstract class SharedJavaMainTab
extends AbstractJavaMainTab {
    protected Text fMainText;
    private Button fSearchButton;

    protected void createMainTypeEditor(Composite parent, String text) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)text, (int)2, (int)1, (int)768);
        this.fMainText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SharedJavaMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        ControlAccessibleListener.addListener((Control)this.fMainText, group.getText());
        this.fSearchButton = this.createPushButton((Composite)group, LauncherMessages.AbstractJavaMainTab_2, null);
        this.fSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SharedJavaMainTab.this.handleSearchButtonSelected();
            }
        });
        this.createMainTypeExtensions((Composite)group);
    }

    protected void createMainTypeExtensions(Composite parent) {
    }

    protected abstract void handleSearchButtonSelected();

    protected void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            try {
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaElement}, (boolean)false);
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                IType[] types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), scope, false);
                if (types != null && types.length > 0) {
                    name = types[0].getFullyQualifiedName();
                }
            }
            catch (InterruptedException ie) {
                JDIDebugUIPlugin.log(ie);
            }
            catch (InvocationTargetException ite) {
                JDIDebugUIPlugin.log(ite);
            }
        }
        if (name == null) {
            name = "";
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = "";
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    @Override
    protected void initializeAttributes() {
        super.initializeAttributes();
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, LauncherMessages.SharedJavaMainTab_AttributeLabel_MainTypeName);
    }
}

