/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tools.templates.ui.internal.TemplateExtension;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tools.templates.ui";
    private static Activator plugin;
    private TemplateExtension templateExtension;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.templateExtension = new TemplateExtension();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static String getId() {
        return plugin.getBundle().getSymbolicName();
    }

    public static TemplateExtension getTemplateExtension() {
        return Activator.plugin.templateExtension;
    }

    public static void log(Exception e) {
        if (e instanceof CoreException) {
            plugin.getLog().log(((CoreException)e).getStatus());
        } else {
            plugin.getLog().log((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public static Status createErrorStatus(String message) {
        return Activator.createErrorStatus(message, null);
    }

    public static Status createErrorStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, 4, message, e);
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(String message, Throwable e) {
        Activator.log((IStatus)Activator.createErrorStatus(message, e));
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t, boolean logError) {
        IStatus status;
        if (logError) {
            Activator.log(message, t);
        }
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }
}

