/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.BaseMouseProvider;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;
import org.swtchart.Range;

public class MouseSelectionProvider
extends BaseMouseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private double fStartCoordinate;
    private double fEndCoordinate;
    private boolean fIsUpdate;
    private boolean fDragBeginMarker;

    public MouseSelectionProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
        this.register();
    }

    @Override
    public final void register() {
        this.getChart().getPlotArea().addMouseListener((MouseListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        ((IPlotArea)this.getChart().getPlotArea()).addCustomPaintListener((ICustomPaintListener)this);
    }

    @Override
    public final void deregister() {
        if (!this.getChart().isDisposed()) {
            this.getChart().getPlotArea().removeMouseListener((MouseListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            ((IPlotArea)this.getChart().getPlotArea()).removeCustomPaintListener((ICustomPaintListener)this);
        }
    }

    public void mouseDoubleClick(@Nullable MouseEvent e) {
    }

    public void mouseDown(@Nullable MouseEvent e) {
        if (e != null && e.button == 1) {
            this.fDragBeginMarker = false;
            if ((e.stateMask & 0x20000) != 131072 || this.fEndCoordinate == this.fStartCoordinate) {
                IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
                this.fEndCoordinate = this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            } else {
                double selectionBegin = this.fStartCoordinate;
                double selectionEnd = this.fEndCoordinate;
                IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
                double time = xAxis.getDataCoordinate(e.x);
                if (Math.abs(time - selectionBegin) < Math.abs(time - selectionEnd)) {
                    this.fDragBeginMarker = true;
                    this.fStartCoordinate = time;
                    this.fEndCoordinate = selectionEnd;
                } else {
                    this.fStartCoordinate = selectionBegin;
                    this.fEndCoordinate = time;
                }
            }
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(@Nullable MouseEvent e) {
        if (this.fIsUpdate) {
            if (this.fStartCoordinate > this.fEndCoordinate) {
                double tmp = this.fStartCoordinate;
                this.fStartCoordinate = this.fEndCoordinate;
                this.fEndCoordinate = tmp;
            }
            if (!this.isEmptySelection()) {
                this.getDensityViewer().select(new Range(Double.MIN_VALUE, Double.MAX_VALUE));
            } else {
                this.getDensityViewer().select(new Range(this.fStartCoordinate, this.fEndCoordinate));
            }
            this.fIsUpdate = false;
            this.getChart().redraw();
        }
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (e != null && this.fIsUpdate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            if (this.fDragBeginMarker) {
                this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            } else {
                this.fEndCoordinate = xAxis.getDataCoordinate(e.x);
            }
            this.getChart().redraw();
        }
    }

    private boolean isEmptySelection() {
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        int begin = xAxis.getPixelCoordinate(this.fStartCoordinate);
        int end = xAxis.getPixelCoordinate(this.fEndCoordinate);
        return Math.abs(end - begin) > 2;
    }

    public void paintControl(@Nullable PaintEvent e) {
        if (e == null || !this.isEmptySelection()) {
            return;
        }
        Display display = this.getChart().getDisplay();
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        e.gc.setBackground(display.getSystemColor(9));
        e.gc.setForeground(display.getSystemColor(9));
        e.gc.setLineStyle(1);
        int begin = xAxis.getPixelCoordinate(this.fStartCoordinate);
        e.gc.drawLine(begin, 0, begin, e.height);
        int end = xAxis.getPixelCoordinate(this.fEndCoordinate);
        e.gc.drawLine(end, 0, end, e.height);
        e.gc.setAlpha(150);
        if (Math.abs(this.fEndCoordinate - this.fStartCoordinate) > 1.0) {
            e.gc.setBackground(display.getSystemColor(22));
            int beginX = xAxis.getPixelCoordinate(this.fStartCoordinate);
            int endX = xAxis.getPixelCoordinate(this.fEndCoordinate);
            if (this.fEndCoordinate > this.fStartCoordinate) {
                e.gc.fillRectangle(beginX + 1, 0, endX - beginX - 1, e.height);
            } else {
                e.gc.fillRectangle(endX + 1, 0, beginX - endX - 1, e.height);
            }
        }
    }

    public boolean drawBehindSeries() {
        return false;
    }
}

