/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class BuildConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_CLEAR_CONSOLE = "clearConsole";
    private static final String PREF_CONSOLE_ON_TOP = "consoleOnTop";
    private static final String PREF_AUTO_OPEN_CONSOLE = "autoOpenConsole";
    public static final String PREF_BUILDCONSOLE_WRAP_LINES = "buildConsoleWrapLines";
    public static final String PREF_BUILDCONSOLE_WRAP_LINES_MAX = "buildConsoleWrapLinesMax";
    public static final String PREF_BUILDCONSOLE_FONT = "org.eclipse.cdt.ui.buildconsole.ConsoleFont";
    public static final String PREF_BUILDCONSOLE_TAB_WIDTH = "buildConsoleTabWith";
    public static final String PREF_BUILDCONSOLE_LINES = "buildConsoleLines";
    public static final String PREF_BUILDCONSOLE_UPDATE_DELAY_MS = "buildConsoleUpdateDelayMs";
    public static final String PREF_BUILDCONSOLE_INFO_COLOR = "buildConsoleInfoStreamColor";
    public static final String PREF_BUILDCONSOLE_OUTPUT_COLOR = "buildConsoleOutputStreamColor";
    public static final String PREF_BUILDCONSOLE_ERROR_COLOR = "buildConsoleErrorStreamColor";
    public static final String PREF_BUILDCONSOLE_BACKGROUND_COLOR = "buildConsoleBackgroundColor";
    public static final String PREF_BUILDCONSOLE_PROBLEM_BACKGROUND_COLOR = "buildConsoleProblemBackgroundColor";
    public static final String PREF_BUILDCONSOLE_PROBLEM_WARNING_BACKGROUND_COLOR = "buildConsoleProblemWarningBackgroundColor";
    public static final String PREF_BUILDCONSOLE_PROBLEM_INFO_BACKGROUND_COLOR = "buildConsoleProblemInfoBackgroundColor";
    public static final String PREF_BUILDCONSOLE_PROBLEM_HIGHLIGHTED_COLOR = "buildConsoleProblemHighlightedColor";
    public static final int DEFAULT_BUILDCONSOLE_UPDATE_DELAY_MS = 75;
    private BooleanFieldEditor2 consoleWrapLines;
    private IntegerFieldEditor buildCount;
    private IntegerFieldEditor wrapLinesMax;

    public BuildConsolePreferencePage() {
        super(1);
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.build_console_preference_page");
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor clearConsole = new BooleanFieldEditor(PREF_CLEAR_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.clearConsole.label"), parent);
        this.addField((FieldEditor)clearConsole);
        BooleanFieldEditor autoOpenConsole = new BooleanFieldEditor(PREF_AUTO_OPEN_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.autoOpenConsole.label"), parent);
        this.addField((FieldEditor)autoOpenConsole);
        BooleanFieldEditor consoleOnTop = new BooleanFieldEditor(PREF_CONSOLE_ON_TOP, CUIPlugin.getResourceString("ConsolePreferencePage.consoleOnTop.label"), parent);
        this.addField((FieldEditor)consoleOnTop);
        this.consoleWrapLines = new BooleanFieldEditor2(PREF_BUILDCONSOLE_WRAP_LINES, CUIPlugin.getResourceString("ConsolePreferencePage.consoleWrapLines.label"), parent);
        this.addField((FieldEditor)this.consoleWrapLines);
        this.setWrapLinesEnablement();
        this.buildCount = new IntegerFieldEditor(PREF_BUILDCONSOLE_LINES, CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.label"), parent);
        this.buildCount.getLabelControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.tooltip"));
        this.buildCount.getTextControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.tooltip"));
        this.buildCount.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.errorMessage"));
        this.buildCount.setValidRange(10, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.buildCount);
        IntegerFieldEditor updateDelay = new IntegerFieldEditor(PREF_BUILDCONSOLE_UPDATE_DELAY_MS, CUIPlugin.getResourceString("ConsolePreferencePage.consoleUpdateDelay.label"), parent);
        updateDelay.getLabelControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.consoleUpdateDelay.tooltip"));
        updateDelay.getTextControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.consoleUpdateDelay.tooltip"));
        updateDelay.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.consoleUpdateDelay.errorMessage"));
        updateDelay.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)updateDelay);
        this.wrapLinesMax = new IntegerFieldEditor(PREF_BUILDCONSOLE_WRAP_LINES_MAX, CUIPlugin.getResourceString("ConsolePreferencePage.wrapLinesMax.label"), parent);
        this.wrapLinesMax.getLabelControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.wrapLinesMax.tooltip"));
        this.wrapLinesMax.getTextControl(parent).setToolTipText(CUIPlugin.getResourceString("ConsolePreferencePage.wrapLinesMax.tooltip"));
        this.wrapLinesMax.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.wrapLinesMax.errorMessage"));
        this.wrapLinesMax.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.wrapLinesMax);
        IntegerFieldEditor tabSize = new IntegerFieldEditor(PREF_BUILDCONSOLE_TAB_WIDTH, CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.label"), parent);
        this.addField((FieldEditor)tabSize);
        tabSize.setValidRange(1, 100);
        tabSize.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.errorMessage"));
        this.createLabel(parent, CUIPlugin.getResourceString("ConsolePreferencePage.colorSettings.label"));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_OUTPUT_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.outputColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_INFO_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.infoColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_ERROR_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.errorColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_BACKGROUND_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.backgroundColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_PROBLEM_BACKGROUND_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.problemBackgroundColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_PROBLEM_WARNING_BACKGROUND_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.problemWarningBackgroundColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_PROBLEM_INFO_BACKGROUND_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.problemInfoBackgroundColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_PROBLEM_HIGHLIGHTED_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.problemHighlightedColor.label"), parent));
    }

    private void setWrapLinesEnablement() {
        if ((this.buildCount == null || this.buildCount.isValid()) && (this.wrapLinesMax == null || this.wrapLinesMax.isValid())) {
            boolean enabled;
            int lineCount = this.buildCount != null ? this.buildCount.getIntValue() : BuildConsolePreferencePage.buildConsoleLines();
            int maxCount = this.wrapLinesMax != null ? this.wrapLinesMax.getIntValue() : BuildConsolePreferencePage.wrapLinesMax();
            boolean bl = enabled = lineCount <= maxCount;
            if (this.consoleWrapLines != null) {
                this.consoleWrapLines.setEnabled(enabled, this.getFieldEditorParent());
                if (!enabled) {
                    this.consoleWrapLines.getChangeControl(this.getFieldEditorParent()).setSelection(false);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setWrapLinesEnablement();
        super.propertyChange(event);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public static boolean isClearBuildConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CLEAR_CONSOLE);
    }

    public static boolean isAutoOpenConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_AUTO_OPEN_CONSOLE);
    }

    public static boolean isConsoleOnTop() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CONSOLE_ON_TOP);
    }

    public static boolean isConsoleWrapLines() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_BUILDCONSOLE_WRAP_LINES);
    }

    public static boolean isConsoleWrapLinesAllowed() {
        return BuildConsolePreferencePage.buildConsoleLines() <= BuildConsolePreferencePage.wrapLinesMax();
    }

    public static int wrapLinesMax() {
        return CUIPlugin.getDefault().getPreferenceStore().getInt(PREF_BUILDCONSOLE_WRAP_LINES_MAX);
    }

    public static int buildConsoleLines() {
        return CUIPlugin.getDefault().getPreferenceStore().getInt(PREF_BUILDCONSOLE_LINES);
    }

    public static int buildConsoleUpdateDelayMs() {
        return CUIPlugin.getDefault().getPreferenceStore().getInt(PREF_BUILDCONSOLE_UPDATE_DELAY_MS);
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore prefs, boolean unconditionally) {
        if (unconditionally || !prefs.contains(PREF_CLEAR_CONSOLE)) {
            prefs.setDefault(PREF_CLEAR_CONSOLE, true);
        }
        if (unconditionally || !prefs.contains(PREF_AUTO_OPEN_CONSOLE)) {
            prefs.setDefault(PREF_AUTO_OPEN_CONSOLE, true);
        }
        if (unconditionally || !prefs.contains(PREF_CONSOLE_ON_TOP)) {
            prefs.setDefault(PREF_CONSOLE_ON_TOP, true);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_WRAP_LINES)) {
            prefs.setDefault(PREF_BUILDCONSOLE_WRAP_LINES, false);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_LINES)) {
            prefs.setDefault(PREF_BUILDCONSOLE_LINES, 500);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_WRAP_LINES_MAX)) {
            prefs.setDefault(PREF_BUILDCONSOLE_WRAP_LINES_MAX, 5000);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_UPDATE_DELAY_MS)) {
            prefs.setDefault(PREF_BUILDCONSOLE_UPDATE_DELAY_MS, 75);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_TAB_WIDTH)) {
            prefs.setDefault(PREF_BUILDCONSOLE_TAB_WIDTH, 4);
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_OUTPUT_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_OUTPUT_COLOR, (RGB)new RGB(0, 0, 0));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_INFO_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_INFO_COLOR, (RGB)new RGB(0, 0, 255));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_ERROR_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_ERROR_COLOR, (RGB)new RGB(255, 0, 0));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_BACKGROUND_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_BACKGROUND_COLOR, (RGB)new RGB(255, 255, 255));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_PROBLEM_BACKGROUND_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_PROBLEM_BACKGROUND_COLOR, (RGB)new RGB(254, 231, 224));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_PROBLEM_WARNING_BACKGROUND_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_PROBLEM_WARNING_BACKGROUND_COLOR, (RGB)new RGB(254, 243, 218));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_PROBLEM_INFO_BACKGROUND_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_PROBLEM_INFO_BACKGROUND_COLOR, (RGB)new RGB(244, 247, 254));
        }
        if (unconditionally || !prefs.contains(PREF_BUILDCONSOLE_PROBLEM_HIGHLIGHTED_COLOR)) {
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_PROBLEM_HIGHLIGHTED_COLOR, (RGB)new RGB(255, 0, 0));
        }
    }
}

