/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDECloseMonitor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IDEPlugin
extends AbstractUIPlugin {
    private IWorkbenchListener workbenchListener;
    private static IDEPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.systemtap.ui.ide";
    public static final String SPACE = "space";
    public static final String TAB = "tab";

    public IDEPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.workbenchListener = new IDECloseMonitor();
        PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        TapsetLibrary.init();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        TapsetLibrary.stop();
        ScriptConsole.stopAll();
        PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
        plugin = null;
    }

    public static IDEPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).get();
    }

    public URI createRemoteUri(String path) {
        int port;
        IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String user = p.getString("scpuser");
        String host = p.getString("host");
        if (path == null) {
            path = "";
        }
        if ((port = p.getInt("port")) == 0) {
            port = p.getDefaultInt("port");
        }
        try {
            return new URI("ssh", user, host, port, path, null, null);
        }
        catch (URISyntaxException uri) {
            return null;
        }
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        IDEPlugin.log(status);
    }
}

