/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;

public class DeclarationScope {
    private static final AtomicLong UNIQUE_ID_FACTORY = new AtomicLong(0L);
    private final DeclarationScope fParentScope;
    private @NonNull Map<String, DeclarationScope> fChildren = new HashMap<String, DeclarationScope>();
    private final Map<String, StructDeclaration> fStructs = new HashMap<String, StructDeclaration>();
    private final Map<String, EnumDeclaration> fEnums = new HashMap<String, EnumDeclaration>();
    private final Map<String, VariantDeclaration> fVariants = new HashMap<String, VariantDeclaration>();
    private final Map<String, IDeclaration> fTypes = new HashMap<String, IDeclaration>();
    private final Map<String, IDeclaration> fIdentifiers = new HashMap<String, IDeclaration>();
    private String fName;
    private long fUniqueId;

    public DeclarationScope() {
        this((DeclarationScope)null, (String)null);
    }

    public DeclarationScope(DeclarationScope parentScope, String name) {
        this.fParentScope = parentScope;
        this.fName = name;
        this.fUniqueId = UNIQUE_ID_FACTORY.getAndIncrement();
        if (parentScope != null) {
            parentScope.registerChild(name, this);
        }
    }

    private DeclarationScope(DeclarationScope parentScope, DeclarationScope source) {
        this(parentScope, source.fName);
        this.fUniqueId = source.fUniqueId;
        this.fStructs.putAll(source.fStructs);
        this.fEnums.putAll(source.fEnums);
        this.fVariants.putAll(source.fVariants);
        this.fTypes.putAll(source.fTypes);
        this.fIdentifiers.putAll(source.fIdentifiers);
        for (DeclarationScope child : source.fChildren.values()) {
            this.addChild(child);
        }
    }

    private void registerChild(String name, DeclarationScope declarationScope) {
        this.fChildren.put(name, declarationScope);
    }

    private boolean checkValid(DeclarationScope childSource) {
        long uniqueId = childSource.fUniqueId;
        DeclarationScope parent = this;
        while (parent != null) {
            if (uniqueId == parent.fUniqueId) {
                return false;
            }
            parent = parent.getParentScope();
        }
        return true;
    }

    public DeclarationScope getParentScope() {
        return this.fParentScope;
    }

    public void setName(String name) {
        if (this.hasParent()) {
            this.fParentScope.fChildren.remove(this.fName);
            this.fParentScope.fChildren.put(name, this);
            this.fName = name;
        }
    }

    public void registerType(String name, IDeclaration declaration) throws ParseException {
        if (this.fTypes.containsKey(name)) {
            throw new ParseException("Type has already been defined:" + name);
        }
        this.fTypes.put(name, declaration);
    }

    public void registerIdentifier(String name, IDeclaration declaration) throws ParseException {
        if (this.fIdentifiers.containsKey(name)) {
            throw new ParseException("Identifier has already been defined:" + name);
        }
        this.fIdentifiers.put(name, declaration);
    }

    public void registerStruct(String name, StructDeclaration declaration) throws ParseException {
        if (this.fStructs.containsKey(name)) {
            throw new ParseException("Struct has already been defined:" + name);
        }
        this.fStructs.put(name, declaration);
        String structPrefix = "struct ";
        this.registerType(String.valueOf(structPrefix) + name, declaration);
    }

    public void registerEnum(String name, EnumDeclaration declaration) throws ParseException {
        if (this.lookupEnum(name) != null) {
            throw new ParseException("Enum has already been defined:" + name);
        }
        this.fEnums.put(name, declaration);
        String enumPrefix = "enum ";
        this.registerType(String.valueOf(enumPrefix) + name, declaration);
    }

    public void registerVariant(String name, VariantDeclaration declaration) throws ParseException {
        VariantDeclaration lookupVariant = this.lookupVariant(name);
        if (declaration.equals(lookupVariant)) {
            return;
        }
        if (lookupVariant != null) {
            throw new ParseException("Variant has already been defined:" + name);
        }
        this.fVariants.put(name, declaration);
        String variantPrefix = "variant ";
        this.registerType(String.valueOf(variantPrefix) + name, declaration);
    }

    public @Nullable DeclarationScope lookupChild(String name) {
        return this.fChildren.get(name);
    }

    public @Nullable DeclarationScope lookupChildRecursive(String name) {
        DeclarationScope declarationScope = this.fChildren.get(name);
        if (declarationScope == null && this.fParentScope != null) {
            return this.fParentScope.lookupChildRecursive(name);
        }
        return declarationScope;
    }

    public IDeclaration lookupType(String name) {
        return this.fTypes.get(name);
    }

    public IDeclaration lookupTypeRecursive(String name) {
        IDeclaration declaration = this.lookupType(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.hasParent()) {
            return this.fParentScope.lookupTypeRecursive(name);
        }
        return null;
    }

    public StructDeclaration lookupStruct(String name) {
        return this.fStructs.get(name);
    }

    public StructDeclaration lookupStructRecursive(String name) {
        StructDeclaration declaration = this.lookupStruct(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.hasParent()) {
            return this.fParentScope.lookupStructRecursive(name);
        }
        return null;
    }

    public EnumDeclaration lookupEnum(String name) {
        return this.fEnums.get(name);
    }

    public EnumDeclaration lookupEnumRecursive(String name) {
        EnumDeclaration declaration = this.lookupEnum(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.hasParent()) {
            return this.fParentScope.lookupEnumRecursive(name);
        }
        return null;
    }

    public VariantDeclaration lookupVariant(String name) {
        return this.fVariants.get(name);
    }

    public VariantDeclaration lookupVariantRecursive(String name) {
        VariantDeclaration declaration = this.lookupVariant(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.hasParent()) {
            return this.fParentScope.lookupVariantRecursive(name);
        }
        return null;
    }

    private boolean hasParent() {
        return this.fParentScope != null;
    }

    public IDeclaration lookupIdentifier(String identifier) {
        return this.fIdentifiers.get(identifier);
    }

    public IDeclaration lookupIdentifierRecursive(String identifier) {
        if (identifier.contains(".")) {
            String[] scopes = identifier.split("\\.");
            return this.lookupIdentifierRecursive(scopes);
        }
        IDeclaration declaration = this.lookupIdentifier(identifier);
        if (declaration != null) {
            return declaration;
        }
        if (this.hasParent()) {
            return this.fParentScope.lookupIdentifierRecursive(identifier);
        }
        return null;
    }

    private IDeclaration lookupIdentifierRecursive(String[] scopes) {
        if (scopes.length < 1) {
            return null;
        }
        DeclarationScope scope = this;
        if ((scope = DeclarationScope.lookupRoot(scopes, scope)) == null) {
            return null;
        }
        int i = 1;
        while (i < scopes.length) {
            String scopeName = scopes[i];
            if (scope == null) {
                return null;
            }
            IDeclaration declaration = this.lookupIdentifierElement(scope, scopeName, Arrays.copyOfRange(scopes, i, scopes.length));
            if (declaration != null) {
                return declaration;
            }
            scope = scope.fChildren.get(scopeName);
            ++i;
        }
        return null;
    }

    private static DeclarationScope lookupRoot(String[] scopes, DeclarationScope originScope) {
        DeclarationScope scope = originScope;
        String rootElement = scopes[0];
        while (!rootElement.equals(scope.fName)) {
            if (!scope.hasParent()) {
                return scope.fChildren.get(rootElement);
            }
            scope = scope.getParentScope();
        }
        return scope;
    }

    private IDeclaration lookupIdentifierElement(DeclarationScope scope, String scopeName, String[] scopes) {
        if (scope.fStructs.containsKey(scopeName)) {
            return this.lookupStructScope(scope, scopeName, scopes);
        }
        if (scope.fTypes.containsKey(scopeName)) {
            return scope.fTypes.get(scopeName);
        }
        if (scope.fEnums.containsKey(scopeName)) {
            return scope.fEnums.get(scopeName);
        }
        if (scope.fIdentifiers.containsKey(scopeName)) {
            return scope.fIdentifiers.get(scopeName);
        }
        return null;
    }

    private IDeclaration lookupStructScope(DeclarationScope scope, String scopeName, String[] scopes) {
        IDeclaration structDeclaration = scope.fStructs.get(scopeName);
        if (scopes.length <= 1) {
            return structDeclaration;
        }
        return this.lookupIdentifierStructElement((StructDeclaration)structDeclaration, scopes[1], Arrays.copyOfRange(scopes, 2, scopes.length));
    }

    private IDeclaration lookupIdentifierStructElement(StructDeclaration structDeclaration, String string, String[] children) {
        IDeclaration field = structDeclaration.getField(string);
        if (children == null || children.length <= 0) {
            return field;
        }
        if (field instanceof StructDeclaration) {
            StructDeclaration fieldStructDeclaration = (StructDeclaration)field;
            return this.lookupIdentifierStructElement(fieldStructDeclaration, children[0], Arrays.copyOfRange(children, 1, children.length));
        }
        return null;
    }

    public Set<String> getTypeNames() {
        return this.fTypes.keySet();
    }

    public void replaceType(String name, IDeclaration newType) throws ParseException {
        if (!this.fTypes.containsKey(name)) {
            throw new ParseException("Trace does not contain type:" + name);
        }
        this.fTypes.put(name, newType);
    }

    public void addChild(DeclarationScope scope) {
        if (this.checkValid(scope)) {
            DeclarationScope scopeCopy = new DeclarationScope(this, scope);
            this.registerChild(scopeCopy.fName, scopeCopy);
        }
    }

    public String toString() {
        return "Scope : " + this.fName + " children: " + this.fChildren.size() + (this.fParentScope == null ? "" : " parent " + this.fParentScope.fName);
    }
}

