﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/migrationhub-config/MigrationHubConfig_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace MigrationHubConfig
{
namespace Model
{
  class AWS_MIGRATIONHUBCONFIG_API GetHomeRegionResult
  {
  public:
    GetHomeRegionResult();
    GetHomeRegionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetHomeRegionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline const Aws::String& GetHomeRegion() const{ return m_homeRegion; }

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline void SetHomeRegion(const Aws::String& value) { m_homeRegion = value; }

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline void SetHomeRegion(Aws::String&& value) { m_homeRegion = std::move(value); }

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline void SetHomeRegion(const char* value) { m_homeRegion.assign(value); }

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline GetHomeRegionResult& WithHomeRegion(const Aws::String& value) { SetHomeRegion(value); return *this;}

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline GetHomeRegionResult& WithHomeRegion(Aws::String&& value) { SetHomeRegion(std::move(value)); return *this;}

    /**
     * <p>The name of the home region of the calling account.</p>
     */
    inline GetHomeRegionResult& WithHomeRegion(const char* value) { SetHomeRegion(value); return *this;}

  private:

    Aws::String m_homeRegion;
  };

} // namespace Model
} // namespace MigrationHubConfig
} // namespace Aws
