/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.ConfigurationFileManagerKt;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v1.nodes.MappingNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0011\u001a\u00020\f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007R$\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "clearableLazyValues", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "kotlin.jvm.PlatformType", "yamlData", "Lorg/snakeyaml/engine/v1/nodes/MappingNode;", "addFileListener", "", "findValueNode", "namePath", "", "getConfigurationNode", "registerClearableLazyValue", "value", "Companion", "intellij.configurationScript"})
public final class ConfigurationFileManager {
    private final ConcurrentList<SynchronizedClearableLazy<?>> clearableLazyValues;
    private final SynchronizedClearableLazy<MappingNode> yamlData;
    public static final Companion Companion = new Companion(null);

    public final void registerClearableLazyValue(@NotNull SynchronizedClearableLazy<?> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.clearableLazyValues.add(value);
    }

    private final void addFileListener(Project project) {
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){
            final /* synthetic */ ConfigurationFileManager this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileCopyEvent) continue;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        if (((VFileCreateEvent)vFileEvent).isDirectory()) continue;
                        String string = ((VFileCreateEvent)vFileEvent).getChildName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.childName");
                        if (!ConfigurationFileManagerKt.isConfigurationFile(string)) {
                            continue;
                        }
                    } else {
                        VirtualFile file;
                        if (vFileEvent.getFile() == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"event.file ?: continue");
                        if (!ConfigurationFileManagerKt.isConfigurationFile(file)) continue;
                    }
                    Iterable $this$forEach$iv = (Iterable)ConfigurationFileManager.access$getClearableLazyValues$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        SynchronizedClearableLazy it = (SynchronizedClearableLazy)element$iv;
                        boolean bl = false;
                        it.drop();
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Nullable
    public final MappingNode getConfigurationNode() {
        return (MappingNode)this.yamlData.getValue();
    }

    @Nullable
    public final MappingNode findValueNode(@NotNull String namePath) {
        Intrinsics.checkParameterIsNotNull((Object)namePath, (String)"namePath");
        MappingNode mappingNode = (MappingNode)this.yamlData.getValue();
        if (mappingNode == null) {
            return null;
        }
        return ConfigurationFileManagerKt.findValueNodeByPath(namePath, mappingNode);
    }

    public ConfigurationFileManager(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"ContainerUtil.createConc\u2026onizedClearableLazy<*>>()");
        this.clearableLazyValues = concurrentList;
        this.yamlData = new SynchronizedClearableLazy((Function0)new Function0<MappingNode>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final MappingNode invoke() {
                Path path = ConfigurationFileManagerKt.access$findConfigurationFile(this.$project);
                if (path == null) {
                    return null;
                }
                Path file = path;
                try {
                    InputStream inputStream;
                    InputStream inputStream2 = PathKt.inputStreamIfExists((Path)file);
                    if (inputStream2 == null) {
                        return null;
                    }
                    InputStream inputStream3 = inputStream = inputStream2;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    Closeable closeable = inputStream3;
                    int n = 0;
                    closeable = new InputStreamReader((InputStream)closeable, charset);
                    n = 8192;
                    boolean bl2 = false;
                    return ConfigurationFileManagerKt.doRead(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n));
                }
                catch (Throwable e) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Cannot parse \"" + file + '\"', e);
                    return null;
                }
            }
            {
                this.$project = project;
                super(0);
            }
        });
        this.registerClearableLazyValue(this.yamlData);
        this.addFileListener(project);
    }

    public static final /* synthetic */ ConcurrentList access$getClearableLazyValues$p(ConfigurationFileManager $this) {
        return $this.clearableLazyValues;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/configurationScript/ConfigurationFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.configurationScript"})
    public static final class Companion {
        @NotNull
        public final ConfigurationFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = ServiceManager.getService((Project)$this$service$iv, ConfigurationFileManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            return (ConfigurationFileManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

