/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = JBColor.namedColor((String)"VersionControl.Log.Commit.currentBranchBackground", (Color)new JBColor(new Color(228, 250, 255), new Color(63, 71, 73)));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    @NotNull
    private final Map<VirtualFile, Boolean> myIsHighlighted;

    public CurrentBranchHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        if (logData == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(0);
        }
        if (logUi == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(1);
        }
        this.myIsHighlighted = new HashMap<VirtualFile, Boolean>();
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (details == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(2);
        }
        if (isSelected || !this.myLogUi.isHighlighterEnabled("CURRENT_BRANCH")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(3);
            }
            return vcsCommitStyle;
        }
        if (!this.myIsHighlighted.getOrDefault(details.getRoot(), false).booleanValue()) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(4);
            }
            return vcsCommitStyle;
        }
        Condition<Integer> condition = this.myLogData.getContainingBranchesGetter().getContainedInCurrentBranchCondition(details.getRoot());
        if (condition.value((Object)commitId)) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(5);
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(6);
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(7);
        }
        String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch(dataPack.getFilters(), dataPack.getRefs());
        this.myIsHighlighted.clear();
        boolean isHeadFilter = "HEAD".equals(singleFilteredBranch);
        for (VirtualFile root : dataPack.getLogProviders().keySet()) {
            String currentBranch = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getCurrentBranch(root);
            this.myIsHighlighted.put(root, !isHeadFilter && currentBranch != null && !currentBranch.equals(singleFilteredBranch));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            if (logData == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (logUi == null) {
                Factory.$$$reportNull$$$0(1);
            }
            CurrentBranchHighlighter currentBranchHighlighter = new CurrentBranchHighlighter(logData, logUi);
            if (currentBranchHighlighter == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return currentBranchHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("Current Branch" == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return "Current Branch";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logUi";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHighlighter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

