/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.reveal;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.RevealManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.reveal.RevealItemInfo;
import com.intellij.xdebugger.impl.reveal.RevealMemberValue;
import com.intellij.xdebugger.impl.reveal.RevealParentValue;
import com.intellij.xdebugger.impl.reveal.RevealValue;
import com.intellij.xdebugger.impl.reveal.XDebuggerRevealListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000fJ\b\u0010 \u001a\u00020\u001aH\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"J\u0010\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0005J\u0010\u0010&\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\nJ\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020\u000fJ\u0016\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u00060"}, d2={"Lcom/intellij/xdebugger/impl/reveal/XDebuggerRevealManager;", "", "()V", "compoundComparator", "Ljava/util/Comparator;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "Lkotlin/Comparator;", "getCompoundComparator", "()Ljava/util/Comparator;", "myActiveNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "myListeners", "", "Lcom/intellij/xdebugger/impl/reveal/XDebuggerRevealListener;", "myNodeHoverLifetime", "Lcom/intellij/openapi/Disposable;", "myRevealIconAlarm", "Lcom/intellij/util/Alarm;", "myRevealedMembers", "Ljava/util/HashMap;", "", "Lcom/intellij/xdebugger/impl/reveal/RevealItemInfo;", "Lkotlin/collections/HashMap;", "revealComparator", "getRevealComparator", "addItemInfo", "", "typeName", "fieldName", "addListener", "listener", "disposable", "disposeCurrentNodeHoverSubscription", "getRevealItemInfos", "", "isItemRevealed", "", "node", "isRevealSupported", "loadState", "state", "Lcom/intellij/xdebugger/impl/RevealManagerState;", "onNodeHovered", "lifetimeHolder", "removeItemInfo", "removeListener", "saveState", "Companion", "intellij.platform.debugger.impl"})
public class XDebuggerRevealManager {
    private final List<XDebuggerRevealListener> myListeners;
    private Disposable myNodeHoverLifetime;
    private XDebuggerTreeNode myActiveNode;
    private HashMap<String, RevealItemInfo> myRevealedMembers;
    private final Alarm myRevealIconAlarm;
    @NotNull
    private final Comparator<XValueNodeImpl> revealComparator;
    @NotNull
    private final Comparator<XValueNodeImpl> compoundComparator;
    private static final long DEFAULT_ICON_DELAY = 300L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Comparator<XValueNodeImpl> getRevealComparator() {
        return this.revealComparator;
    }

    @NotNull
    public final Comparator<XValueNodeImpl> getCompoundComparator() {
        return this.compoundComparator;
    }

    public final void onNodeHovered(@Nullable XDebuggerTreeNode node, @NotNull Disposable lifetimeHolder) {
        Intrinsics.checkParameterIsNotNull((Object)lifetimeHolder, (String)"lifetimeHolder");
        if (Intrinsics.areEqual((Object)this.myActiveNode, (Object)node)) {
            return;
        }
        this.disposeCurrentNodeHoverSubscription();
        if (!this.isRevealSupported(node)) {
            return;
        }
        XDebuggerTreeNode xDebuggerTreeNode = node;
        if (!(xDebuggerTreeNode instanceof XValueNodeImpl)) {
            xDebuggerTreeNode = null;
        }
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)xDebuggerTreeNode;
        if (xValueNodeImpl == null) {
            return;
        }
        XValueNodeImpl valueNode = xValueNodeImpl;
        XValue xValue = (XValue)((XValueNodeImpl)node).getValueContainer();
        if (!(xValue instanceof RevealMemberValue)) {
            xValue = null;
        }
        RevealMemberValue revealMemberValue = (RevealMemberValue)xValue;
        if (revealMemberValue == null) {
            return;
        }
        RevealMemberValue revealValue = revealMemberValue;
        if (!revealValue.canBeRevealed() || this.isItemRevealed((XValueNodeImpl)node)) {
            return;
        }
        XValuePresentation xValuePresentation = valueNode.getValuePresentation();
        if (xValuePresentation == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)xValuePresentation, (String)"valueNode.valuePresentation ?: return");
        XValuePresentation valuePresentation = xValuePresentation;
        boolean hasChildren = !valueNode.isLeaf();
        Icon oldIcon = valueNode.getIcon();
        Disposable changeIconLifetime2 = new Disposable(this, node, oldIcon, valuePresentation, hasChildren){
            final /* synthetic */ XDebuggerRevealManager this$0;
            final /* synthetic */ XDebuggerTreeNode $node;
            final /* synthetic */ Icon $oldIcon;
            final /* synthetic */ XValuePresentation $valuePresentation;
            final /* synthetic */ boolean $hasChildren;

            public final void dispose() {
                if (Intrinsics.areEqual((Object)((XValueNodeImpl)this.$node).getIcon(), (Object)this.$oldIcon) ^ true) {
                    ((XValueNodeImpl)this.$node).setPresentation(this.$oldIcon, this.$valuePresentation, this.$hasChildren);
                }
                XDebuggerRevealManager.access$setMyActiveNode$p(this.this$0, null);
            }
            {
                this.this$0 = xDebuggerRevealManager;
                this.$node = xDebuggerTreeNode;
                this.$oldIcon = icon;
                this.$valuePresentation = xValuePresentation;
                this.$hasChildren = bl;
            }
        };
        this.myActiveNode = node;
        this.myRevealIconAlarm.addRequest(new Runnable(node, valuePresentation, hasChildren){
            final /* synthetic */ XDebuggerTreeNode $node;
            final /* synthetic */ XValuePresentation $valuePresentation;
            final /* synthetic */ boolean $hasChildren;

            public final void run() {
                ((XValueNodeImpl)this.$node).setPresentation(AllIcons.Debugger.Reveal.RevealOff, this.$valuePresentation, this.$hasChildren);
            }
            {
                this.$node = xDebuggerTreeNode;
                this.$valuePresentation = xValuePresentation;
                this.$hasChildren = bl;
            }
        }, 300L);
        this.myNodeHoverLifetime = changeIconLifetime2;
        Disposer.register((Disposable)lifetimeHolder, (Disposable)changeIconLifetime2);
    }

    public final void addListener(@NotNull XDebuggerRevealListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.myListeners.add(listener2);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(this, listener2){
            final /* synthetic */ XDebuggerRevealManager this$0;
            final /* synthetic */ XDebuggerRevealListener $listener;

            public final void dispose() {
                XDebuggerRevealManager.access$getMyListeners$p(this.this$0).remove(this.$listener);
            }
            {
                this.this$0 = xDebuggerRevealManager;
                this.$listener = xDebuggerRevealListener;
            }
        });
    }

    public final void removeListener(@NotNull XDebuggerRevealListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.myListeners.remove(listener2);
    }

    @NotNull
    public final List<RevealItemInfo> getRevealItemInfos() {
        Collection<RevealItemInfo> collection = this.myRevealedMembers.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"myRevealedMembers.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void addItemInfo(@NotNull String typeName, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        RevealItemInfo info = new RevealItemInfo(typeName, fieldName);
        ((Map)this.myRevealedMembers).put(info.getKey(), info);
        for (XDebuggerRevealListener listener2 : this.myListeners) {
            listener2.onRevealItemAdded(info);
        }
    }

    public final void removeItemInfo(@NotNull String typeName, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        String key = RevealItemInfo.Companion.getKey(typeName, fieldName);
        RevealItemInfo revealItemInfo = this.myRevealedMembers.get(key);
        if (revealItemInfo == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)revealItemInfo, (String)"myRevealedMembers[key] ?: return");
        RevealItemInfo info = revealItemInfo;
        this.myRevealedMembers.remove(key);
        for (XDebuggerRevealListener listener2 : this.myListeners) {
            listener2.onRevealItemRemoved(info);
        }
    }

    public final boolean isItemRevealed(@Nullable XValueNodeImpl node) {
        Object object;
        XValueNodeImpl xValueNodeImpl = node;
        TreeNode treeNode = xValueNodeImpl != null ? xValueNodeImpl.getParent() : null;
        if (!(treeNode instanceof XValueContainerNode)) {
            treeNode = null;
        }
        XValueContainerNode xValueContainerNode = (XValueContainerNode)treeNode;
        Object object2 = xValueContainerNode != null ? xValueContainerNode.getValueContainer() : null;
        if (!(object2 instanceof RevealParentValue)) {
            object2 = null;
        }
        if ((object = (RevealParentValue)object2) == null || (object = object.getTypeName()) == null) {
            return false;
        }
        Object typeName = object;
        String string = node.getName();
        if (string == null) {
            string = "";
        }
        return this.myRevealedMembers.containsKey(RevealItemInfo.Companion.getKey((String)typeName, string));
    }

    private final void disposeCurrentNodeHoverSubscription() {
        Disposable disposable = this.myNodeHoverLifetime;
        if (disposable == null) {
            return;
        }
        Disposer.dispose((Disposable)disposable);
        this.myRevealIconAlarm.cancelAllRequests();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveState(@NotNull RevealManagerState state) {
        Collection<RevealItemInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        Iterable iterable = MapsKt.toList((Map)this.myRevealedMembers);
        RevealManagerState revealManagerState = state;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            RevealItemInfo revealItemInfo = (RevealItemInfo)it.getSecond();
            collection.add(revealItemInfo);
        }
        collection = (List)destination$iv$iv;
        revealManagerState.setRevealedMembersList(CollectionsKt.toMutableList((Collection)collection));
    }

    /*
     * WARNING - void declaration
     */
    public final void loadState(@NotNull RevealManagerState state) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        Iterable iterable = state.getRevealedMembersList();
        Map map2 = this.myRevealedMembers;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RevealItemInfo revealItemInfo = (RevealItemInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getKey(), (Object)it);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        MapsKt.putAll((Map)map2, (Iterable)collection);
    }

    public final boolean isRevealSupported(@Nullable XDebuggerTreeNode node) {
        if (!(node instanceof XValueContainerNode)) {
            return false;
        }
        return ((XValueContainerNode)node).getValueContainer() instanceof RevealValue;
    }

    public XDebuggerRevealManager() {
        List list2;
        XDebuggerRevealManager xDebuggerRevealManager = this;
        boolean bl = false;
        xDebuggerRevealManager.myListeners = list2 = (List)new ArrayList();
        this.myRevealedMembers = new HashMap();
        this.myRevealIconAlarm = new Alarm();
        Comparator comparator2 = Comparator.comparing(new Function<T, U>(this){
            final /* synthetic */ XDebuggerRevealManager this$0;

            public final boolean apply(XValueNodeImpl it) {
                return !this.this$0.isItemRevealed(it);
            }
            {
                this.this$0 = xDebuggerRevealManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(comparator2, (String)"Comparator.comparing<XVa\u2026> { !isItemRevealed(it) }");
        this.revealComparator = comparator2;
        Comparator<XValueNodeImpl> comparator3 = XValueNodeImpl.COMPARATOR;
        Intrinsics.checkExpressionValueIsNotNull(comparator3, (String)"XValueNodeImpl.COMPARATOR");
        this.compoundComparator = ComparisonsKt.then(this.revealComparator, comparator3);
    }

    public static final /* synthetic */ XDebuggerTreeNode access$getMyActiveNode$p(XDebuggerRevealManager $this) {
        return $this.myActiveNode;
    }

    public static final /* synthetic */ void access$setMyActiveNode$p(XDebuggerRevealManager $this, XDebuggerTreeNode xDebuggerTreeNode) {
        $this.myActiveNode = xDebuggerTreeNode;
    }

    public static final /* synthetic */ List access$getMyListeners$p(XDebuggerRevealManager $this) {
        return $this.myListeners;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/reveal/XDebuggerRevealManager$Companion;", "", "()V", "DEFAULT_ICON_DELAY", "", "getInstance", "Lcom/intellij/xdebugger/impl/reveal/XDebuggerRevealManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        @NotNull
        public final XDebuggerRevealManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
            if (xDebuggerManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerManagerImpl");
            }
            XDebuggerRevealManager xDebuggerRevealManager = ((XDebuggerManagerImpl)xDebuggerManager).getRevealManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerRevealManager, (String)"(XDebuggerManager.getIns\u2026anagerImpl).revealManager");
            return xDebuggerRevealManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

