/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class DarculaSeparatorUI
extends BasicSeparatorUI {
    private static final JBValue STRIPE_WIDTH = new JBValue.Float(1.0f);
    private static final JBValue STRIPE_INDENT = new JBValue.Float(1.0f);

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaSeparatorUI();
    }

    @Override
    protected void installDefaults(JSeparator s) {
        Color bg = s.getForeground();
        if (bg == null || bg instanceof UIResource) {
            s.setForeground((Color)JBColor.namedColor((String)this.getColorResourceName(), (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
        }
        LookAndFeel.installProperty(s, "opaque", Boolean.FALSE);
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        Rectangle r = new Rectangle(c2.getSize());
        g.setColor(c2.getForeground());
        if (((JSeparator)c2).getOrientation() == 1) {
            g.fillRect(r.x + this.getStripeIndent(), r.y, this.getStripeWidth(), r.height);
        } else {
            g.fillRect(r.x, r.y + this.getStripeIndent(), r.width, this.getStripeWidth());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        return ((JSeparator)c2).getOrientation() == 1 ? JBUI.size((int)3, (int)0) : JBUI.size((int)0, (int)3);
    }

    protected int getStripeIndent() {
        return STRIPE_INDENT.get();
    }

    protected int getStripeWidth() {
        return STRIPE_WIDTH.get();
    }

    protected String getColorResourceName() {
        return "Separator.separatorColor";
    }
}

