/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class InstalledPluginsState {
    private final Object myLock = new Object();
    private final Map<PluginId, IdeaPluginDescriptor> myInstalledPlugins = ContainerUtil.newIdentityHashMap();
    private final Map<PluginId, IdeaPluginDescriptor> myUpdatedPlugins = ContainerUtil.newIdentityHashMap();
    private final Set<String> myOutdatedPlugins = new SmartHashSet();

    @Nullable
    public static InstalledPluginsState getInstanceIfLoaded() {
        return ApplicationManagerEx.isAppLoaded() ? InstalledPluginsState.getInstance() : null;
    }

    public static InstalledPluginsState getInstance() {
        return (InstalledPluginsState)ServiceManager.getService(InstalledPluginsState.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getInstalledPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<IdeaPluginDescriptor> collection = Collections.unmodifiableCollection(this.myInstalledPlugins.values());
        // MONITOREXIT : object
        if (collection != null) return collection;
        InstalledPluginsState.$$$reportNull$$$0(0);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewerVersion(@NotNull PluginId id) {
        if (id == null) {
            InstalledPluginsState.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            return !this.wasUpdated(id) && this.myOutdatedPlugins.contains(id.getIdString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalled(@NotNull PluginId id) {
        if (id == null) {
            InstalledPluginsState.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdated(@NotNull PluginId id) {
        if (id == null) {
            InstalledPluginsState.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorDownload(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId id;
        IdeaPluginDescriptor existing;
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(4);
        }
        if ((existing = PluginManager.getPlugin(id = descriptor2.getPluginId())) == null || existing.isBundled() && !existing.allowBundledUpdate() || this.wasUpdated(id)) {
            return;
        }
        boolean supersedes = PluginManagerCore.isCompatible(descriptor2) && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(existing, descriptor2.getVersion()) > 0;
        String idString = id.getIdString();
        Object object = this.myLock;
        synchronized (object) {
            if (supersedes) {
                this.myOutdatedPlugins.add(idString);
            } else {
                this.myOutdatedPlugins.remove(idString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsState.$$$reportNull$$$0(5);
        }
        PluginId id = descriptor2.getPluginId();
        boolean existing = PluginManager.isPluginInstalled(id);
        Object object = this.myLock;
        synchronized (object) {
            this.myOutdatedPlugins.remove(id.getIdString());
            if (existing) {
                this.myUpdatedPlugins.put(id, descriptor2);
            } else {
                this.myInstalledPlugins.put(id, descriptor2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPlugins";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasNewerVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wasInstalled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wasUpdated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onDescriptorDownload";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

