/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionManagerImpl
extends IntentionManager {
    private static final Logger LOG = Logger.getInstance(IntentionManagerImpl.class);
    private final List<IntentionAction> myActions;
    private final AtomicReference<ScheduledFuture<?>> myScheduledFuture = new AtomicReference();
    private boolean myIntentionsDisabled;
    private boolean checkedForDuplicates;

    public IntentionManagerImpl() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        for (IntentionActionBean extension : IntentionManager.EP_INTENTION_ACTIONS.getExtensionList()) {
            actions.add(new IntentionActionWrapper(extension, extension.getCategories()));
        }
        this.myActions = ContainerUtil.createLockFreeCopyOnWriteList(actions);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action2, String ... category) {
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(0);
        }
        if (category == null) {
            IntentionManagerImpl.$$$reportNull$$$0(1);
        }
        this.addAction(action2);
        String descriptionDirectoryName = action2 instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action2).getDescriptionDirectoryName() : IntentionActionWrapper.getDescriptionDirectoryName(action2.getClass().getName());
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        settings.registerIntentionMetaData(action2, category, descriptionDirectoryName);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerImpl.$$$reportNull$$$0(2);
        }
        this.myActions.remove(intentionAction);
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        settings.unregisterMetaData(intentionAction);
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context) {
        if (displayKey == null) {
            IntentionManagerImpl.$$$reportNull$$$0(3);
        }
        if (context == null) {
            IntentionManagerImpl.$$$reportNull$$$0(4);
        }
        this.checkForDuplicates();
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>(9);
        options.add(new EditInspectionToolsSettingsAction(displayKey));
        options.add(new RunInspectionIntention(displayKey));
        options.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            IntentionManagerImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public IntentionAction createFixAllIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull IntentionAction action2) {
        LocalInspectionToolWrapper localWrapper;
        if (toolWrapper == null) {
            IntentionManagerImpl.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(7);
        }
        this.checkForDuplicates();
        if (toolWrapper instanceof GlobalInspectionToolWrapper && (localWrapper = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper()) != null) {
            toolWrapper = localWrapper;
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action2);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action2 instanceof LocalQuickFix || action2 instanceof QuickFixWrapper)) {
                return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action2);
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + toolWrapper));
        }
        return null;
    }

    private static IntentionAction createFixAllIntentionInternal(@NotNull InspectionToolWrapper toolWrapper, @NotNull IntentionAction action2) {
        if (toolWrapper == null) {
            IntentionManagerImpl.$$$reportNull$$$0(8);
        }
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(9);
        }
        PsiFile file2 = null;
        IntentionAction fix = action2;
        if (action2 instanceof QuickFixWrapper) {
            fix = ((QuickFixWrapper)action2).getFix();
            file2 = ((QuickFixWrapper)action2).getFile();
        }
        return new CleanupInspectionIntention(toolWrapper, (FileModifier)fix, file2, action2.getText());
    }

    @NotNull
    public IntentionAction createCleanupAllIntention() {
        CleanupAllIntention cleanupAllIntention = CleanupAllIntention.INSTANCE;
        if (cleanupAllIntention == null) {
            IntentionManagerImpl.$$$reportNull$$$0(10);
        }
        return cleanupAllIntention;
    }

    @NotNull
    public List<IntentionAction> getCleanupIntentionOptions() {
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
        options.add(EditCleanupProfileIntentionAction.INSTANCE);
        options.add(CleanupOnScopeIntention.INSTANCE);
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            IntentionManagerImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(12);
        }
        if (action2 instanceof LocalQuickFix) {
            LocalQuickFix localQuickFix = (LocalQuickFix)action2;
            if (localQuickFix == null) {
                IntentionManagerImpl.$$$reportNull$$$0(13);
            }
            return localQuickFix;
        }
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = action2.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = action2.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
                try {
                    action2.invoke(project, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (localQuickFix == null) {
            IntentionManagerImpl.$$$reportNull$$$0(14);
        }
        return localQuickFix;
    }

    public void addAction(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(15);
        }
        this.myActions.add(action2);
    }

    @NotNull
    public IntentionAction[] getIntentionActions() {
        if (this.myIntentionsDisabled) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                IntentionManagerImpl.$$$reportNull$$$0(16);
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        IntentionAction[] intentionActionArray = this.myActions.toArray(IntentionAction.EMPTY_ARRAY);
        if (intentionActionArray == null) {
            IntentionManagerImpl.$$$reportNull$$$0(17);
        }
        return intentionActionArray;
    }

    @NotNull
    public IntentionAction[] getAvailableIntentionActions() {
        if (this.myIntentionsDisabled) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                IntentionManagerImpl.$$$reportNull$$$0(18);
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        this.checkForDuplicates();
        ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(this.myActions.size());
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        for (IntentionAction action2 : this.myActions) {
            if (!settings.isEnabled(action2)) continue;
            list2.add(action2);
        }
        IntentionAction[] intentionActionArray = list2.toArray(IntentionAction.EMPTY_ARRAY);
        if (intentionActionArray == null) {
            IntentionManagerImpl.$$$reportNull$$$0(19);
        }
        return intentionActionArray;
    }

    public void checkForDuplicates() {
        if (this.checkedForDuplicates) {
            return;
        }
        this.checkedForDuplicates = true;
        List duplicates = this.myActions.stream().collect(Collectors.groupingBy(action2 -> IntentionManagerImpl.unwrap(action2).getClass())).values().stream().filter(list2 -> list2.size() > 1).map(dupList -> dupList.size() + " intention duplicates found for " + IntentionManagerImpl.unwrap((IntentionAction)dupList.get(0)) + " (" + ((IntentionAction)dupList.get(0)).getClass() + "; plugin " + PluginManagerCore.getPluginOrPlatformByClassName(((IntentionAction)dupList.get(0)).getClass().getName()) + ")").collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException(duplicates.toString());
        }
    }

    @NotNull
    private static IntentionAction unwrap(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerImpl.$$$reportNull$$$0(20);
        }
        IntentionAction intentionAction = action2 instanceof IntentionActionDelegate ? IntentionManagerImpl.unwrap(((IntentionActionDelegate)action2).getDelegate()) : action2;
        if (intentionAction == null) {
            IntentionManagerImpl.$$$reportNull$$$0(21);
        }
        return intentionAction;
    }

    public boolean hasActiveRequests() {
        return this.myScheduledFuture.get() != null;
    }

    public <T extends Throwable> void withDisabledIntentions(ThrowableRunnable<T> runnable2) throws T {
        boolean oldIntentionsDisabled = this.myIntentionsDisabled;
        this.myIntentionsDisabled = true;
        try {
            runnable2.run();
        }
        finally {
            this.myIntentionsDisabled = oldIntentionsDisabled;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardIntentionOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCleanupAllIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCleanupIntentionOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentionActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionAndMetaData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStandardIntentionOptions";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFixAllIntention";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFixAllIntentionInternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertToFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

