/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InsetPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StaticDelegatePresentation;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "left", "", "right", "top", "down", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;IIII)V", "getDown", "()I", "height", "getHeight", "getLeft", "presentationUnderCursor", "getRight", "getTop", "width", "getWidth", "handleMouse", "", "e", "Ljava/awt/event/MouseEvent;", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.lang.impl"})
public final class InsetPresentation
extends StaticDelegatePresentation {
    private InlayPresentation presentationUnderCursor;
    private final int left;
    private final int right;
    private final int top;
    private final int down;

    @Override
    public int getWidth() {
        return this.getPresentation().getWidth() + this.left + this.right;
    }

    @Override
    public int getHeight() {
        return this.getPresentation().getHeight() + this.top + this.down;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        PresentationUtilKt.withTranslated(g, this.left, this.top, (Function0<Unit>)((Function0)new Function0<Unit>(this, g, attributes){
            final /* synthetic */ InsetPresentation this$0;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ TextAttributes $attributes;

            public final void invoke() {
                this.this$0.getPresentation().paint(this.$g, this.$attributes);
            }
            {
                this.this$0 = insetPresentation;
                this.$g = graphics2D;
                this.$attributes = textAttributes;
                super(0);
            }
        }));
    }

    private final void handleMouse(MouseEvent e, Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        int x = original.x;
        int y = original.y;
        if ((x < this.left || x >= this.left + this.getPresentation().getWidth() || y < this.top || y >= this.top + this.getPresentation().getHeight()) && this.presentationUnderCursor != null) {
            InlayPresentation inlayPresentation = this.presentationUnderCursor;
            if (inlayPresentation != null) {
                inlayPresentation.mouseExited();
            }
            this.presentationUnderCursor = null;
            return;
        }
        Point translated = PresentationUtilKt.translateNew(original, -this.left, -this.top);
        action2.invoke((Object)this.getPresentation(), (Object)translated);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(event, translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                presentation.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(event, translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(this, event){
            final /* synthetic */ InsetPresentation this$0;
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                if (Intrinsics.areEqual((Object)presentation, (Object)InsetPresentation.access$getPresentationUnderCursor$p(this.this$0)) ^ true) {
                    InlayPresentation inlayPresentation = InsetPresentation.access$getPresentationUnderCursor$p(this.this$0);
                    if (inlayPresentation != null) {
                        inlayPresentation.mouseExited();
                    }
                    InsetPresentation.access$setPresentationUnderCursor$p(this.this$0, presentation);
                }
                presentation.mouseMoved(this.$event, point);
            }
            {
                this.this$0 = insetPresentation;
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited() {
        try {
            InlayPresentation inlayPresentation = this.presentationUnderCursor;
            if (inlayPresentation != null) {
                inlayPresentation.mouseExited();
            }
        }
        finally {
            this.presentationUnderCursor = null;
        }
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getDown() {
        return this.down;
    }

    public InsetPresentation(@NotNull InlayPresentation presentation, int left, int right, int top, int down) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        super(presentation);
        this.left = left;
        this.right = right;
        this.top = top;
        this.down = down;
    }

    public /* synthetic */ InsetPresentation(InlayPresentation inlayPresentation, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(inlayPresentation, n, n2, n3, n4);
    }

    public static final /* synthetic */ InlayPresentation access$getPresentationUnderCursor$p(InsetPresentation $this) {
        return $this.presentationUnderCursor;
    }

    public static final /* synthetic */ void access$setPresentationUnderCursor$p(InsetPresentation $this, InlayPresentation inlayPresentation) {
        $this.presentationUnderCursor = inlayPresentation;
    }
}

