/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListenerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.FocusEvent;
import java.util.EventObject;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionPhase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CompletionPhase.class);
    public static final CompletionPhase NoCompletion = new CompletionPhase(null){

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }
    };
    public final CompletionProgressIndicator indicator;

    protected CompletionPhase(@Nullable CompletionProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public void dispose() {
    }

    public abstract int newCompletionStarted(int var1, boolean var2);

    public static class NoSuggestionsHint
    extends ZombiePhase {
        public NoSuggestionsHint(@Nullable LightweightHint hint, CompletionProgressIndicator indicator) {
            super(hint, indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class InsertedSingleItem
    extends ZombiePhase {
        public final Runnable restorePrefix;

        public InsertedSingleItem(CompletionProgressIndicator indicator, Runnable restorePrefix) {
            super(null, indicator);
            this.restorePrefix = restorePrefix;
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            if (repeated) {
                this.indicator.restorePrefix(this.restorePrefix);
            }
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static abstract class ZombiePhase
    extends CompletionPhase {
        protected ZombiePhase(final @Nullable LightweightHint hint, CompletionProgressIndicator indicator) {
            super(indicator);
            Editor editor = indicator.getEditor();
            final HintListener hintListener = new HintListener(){

                @Override
                public void hintHidden(@NotNull EventObject event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$1", "hintHidden"));
                }
            };
            DocumentListener documentListener = new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$2", "beforeDocumentChange"));
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void selectionChanged(@NotNull SelectionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$3", "selectionChanged"));
                }
            };
            CaretListener caretListener = new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/CompletionPhase$ZombiePhase$4", "caretPositionChanged"));
                }
            };
            Document document = editor.getDocument();
            SelectionModel selectionModel = editor.getSelectionModel();
            CaretModel caretModel = editor.getCaretModel();
            if (hint != null) {
                hint.addHintListener(hintListener);
            }
            document.addDocumentListener(documentListener, (Disposable)this);
            selectionModel.addSelectionListener(selectionListener, (Disposable)this);
            caretModel.addCaretListener(caretListener, (Disposable)this);
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    if (hint != null) {
                        hint.removeHintListener(hintListener);
                    }
                }
            });
        }
    }

    public static class ItemsCalculated
    extends CompletionPhase {
        public ItemsCalculated(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class BgCalculation
    extends CompletionPhase {
        boolean modifiersChanged = false;

        public BgCalculation(final CompletionProgressIndicator indicator) {
            super(indicator);
            ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!indicator.getLookup().isLookupDisposed() && !indicator.isCanceled()) {
                        indicator.scheduleRestart();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/completion/CompletionPhase$BgCalculation$1", "beforeWriteActionStart"));
                }
            }, (Disposable)this);
            if (indicator.isAutopopupCompletion()) {
                ((EditorEx)indicator.getEditor()).addFocusListener(new FocusChangeListenerImpl(){

                    @Override
                    public void focusLost(@NotNull Editor editor, @NotNull FocusEvent event) {
                        if (editor == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (ScreenReader.isActive() && indicator.getLookup() != null && event.getOppositeComponent() != null && indicator.getLookup().getComponent() != null && SwingUtilities.getWindowAncestor(event.getOppositeComponent()) == SwingUtilities.getWindowAncestor(indicator.getLookup().getComponent())) {
                            return;
                        }
                        indicator.closeAndFinish(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/codeInsight/completion/CompletionPhase$BgCalculation$2";
                        objectArray[2] = "focusLost";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, this);
            }
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class Synchronous
    extends CompletionPhase {
        public Synchronous(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.assertPhase(NoCompletion.getClass());
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return time;
        }
    }

    public static class CommittingDocuments
    extends CompletionPhase {
        private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Completion Preparation", (int)1);
        boolean replaced;
        private final ActionTracker myTracker;

        CommittingDocuments(@Nullable CompletionProgressIndicator prevIndicator, @NotNull Editor editor) {
            if (editor == null) {
                CommittingDocuments.$$$reportNull$$$0(0);
            }
            super(prevIndicator);
            this.myTracker = new ActionTracker(editor, this);
        }

        public void ignoreCurrentDocumentChange() {
            this.myTracker.ignoreCurrentDocumentChange();
        }

        private boolean isExpired() {
            return CompletionServiceImpl.getCompletionPhase() != this || this.myTracker.hasAnythingHappened();
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }

        @Override
        public void dispose() {
            if (!this.replaced && this.indicator != null) {
                this.indicator.closeAndFinish(true);
            }
        }

        public String toString() {
            return "CommittingDocuments{hasIndicator=" + (this.indicator != null) + '}';
        }

        @ApiStatus.Internal
        public static void scheduleAsyncCompletion(@NotNull Editor _editor, @NotNull CompletionType completionType, @Nullable Condition<? super PsiFile> condition, @NotNull Project project, @Nullable CompletionProgressIndicator prevIndicator) {
            if (_editor == null) {
                CommittingDocuments.$$$reportNull$$$0(1);
            }
            if (completionType == null) {
                CommittingDocuments.$$$reportNull$$$0(2);
            }
            if (project == null) {
                CommittingDocuments.$$$reportNull$$$0(3);
            }
            Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(_editor);
            int offset = topLevelEditor.getCaretModel().getOffset();
            CommittingDocuments phase = new CommittingDocuments(prevIndicator, topLevelEditor);
            CompletionServiceImpl.setCompletionPhase(phase);
            phase.ignoreCurrentDocumentChange();
            boolean autopopup = prevIndicator == null || prevIndicator.isAutopopupCompletion();
            ReadAction.nonBlocking(() -> {
                PsiFile topLevelFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(topLevelEditor.getDocument());
                Editor completionEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(topLevelEditor, topLevelFile, offset);
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(completionEditor.getDocument());
                if (file2 == null || autopopup && CommittingDocuments.shouldSkipAutoPopup(completionEditor, file2) || condition != null && !condition.value((Object)file2)) {
                    return null;
                }
                return completionEditor;
            }).withDocumentsCommitted(project).expireWith((Disposable)phase).expireWhen(() -> phase.isExpired()).finishOnUiThread(ModalityState.current(), completionEditor -> {
                if (completionEditor != null) {
                    int time = prevIndicator == null ? 0 : prevIndicator.getInvocationCount();
                    CodeCompletionHandlerBase handler2 = CodeCompletionHandlerBase.createHandler(completionType, false, autopopup, false);
                    handler2.invokeCompletion(project, (Editor)completionEditor, time, false);
                } else if (phase == CompletionServiceImpl.getCompletionPhase()) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            }).submit((Executor)ourExecutor).onError(__ -> AppUIUtil.invokeOnEdt(() -> {
                if (phase == CompletionServiceImpl.getCompletionPhase()) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            }));
        }

        private static boolean shouldSkipAutoPopup(Editor editor, PsiFile psiFile) {
            int offset = editor.getCaretModel().getOffset();
            int psiOffset = Math.max(0, offset - 1);
            PsiElement elementAt = psiFile.findElementAt(psiOffset);
            if (elementAt == null) {
                return true;
            }
            Language language = PsiUtilCore.findLanguageFromElement((PsiElement)elementAt);
            for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage((Language)language)) {
                ThreeState result2 = confidence.shouldSkipAutopopup(elementAt, psiFile, offset);
                if (result2 == ThreeState.UNSURE) continue;
                LOG.debug(confidence + " has returned shouldSkipAutopopup=" + result2);
                return result2 == ThreeState.YES;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/completion/CompletionPhase$CommittingDocuments";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleAsyncCompletion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

