/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ContainerUtil.compareLexicographically(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private List<Integer> myOrder;
    private final ConcurrentMap<Topic, Object> myPublishers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final List<MessageBusImpl> myChildBuses;
    private volatile ConcurrentMap<String, List<ListenerDescriptor>> myTopicClassToListenerClass;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    RootBus myRootBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;
    private MessageDeliveryListener myListener;

    public MessageBusImpl(@NotNull Object owner, @NotNull MessageBus parentBus) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(0);
        }
        if (parentBus == null) {
            MessageBusImpl.$$$reportNull$$$0(1);
        }
        this(owner);
        this.myParentBus = (MessageBusImpl)parentBus;
        this.myRootBus = this.myParentBus.myRootBus;
        this.myParentBus.onChildBusCreated(this);
        LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        LOG.assertTrue(this.myOrder != null);
    }

    @ApiStatus.Internal
    public void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map) {
        if (map == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        if (this.myTopicClassToListenerClass != null) {
            throw new IllegalStateException("Already set: " + this.myTopicClassToListenerClass);
        }
        this.myTopicClassToListenerClass = map;
    }

    private MessageBusImpl(@NotNull Object owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable((String)this.myOwner);
        this.myOrder = new ArrayList<Integer>();
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusCreated(@NotNull MessageBusImpl childBus) {
        if (childBus == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(childBus.myParentBus == this);
        List<MessageBusImpl> list = this.myChildBuses;
        synchronized (list) {
            int lastChildIndex;
            MessageBusImpl lastChild = this.myChildBuses.isEmpty() ? null : this.myChildBuses.get(this.myChildBuses.size() - 1);
            this.myChildBuses.add(childBus);
            int n = lastChildIndex = lastChild == null ? 0 : lastChild.myOrder.get(lastChild.myOrder.size() - 1);
            if (lastChildIndex == Integer.MAX_VALUE) {
                LOG.error("Too many child buses");
            }
            ArrayList<Integer> childOrder = new ArrayList<Integer>(this.myOrder.size() + 1);
            childOrder.addAll(this.myOrder);
            childOrder.add(lastChildIndex + 1);
            childBus.myOrder = childOrder;
        }
        this.myRootBus.clearSubscriberCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        boolean removed;
        if (childBus == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        List<MessageBusImpl> list = this.myChildBuses;
        synchronized (list) {
            removed = this.myChildBuses.remove(childBus);
        }
        Map map = (Map)this.myRootBus.myWaitingBuses.get();
        if (map != null) {
            map.remove(childBus);
        }
        this.myRootBus.clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        MessageBusConnection messageBusConnection = this.connect(this.myConnectionDisposable);
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register((Disposable)parentDisposable, (Disposable)connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        return messageBusConnectionImpl;
    }

    @NotNull
    protected MessageBusConnection createConnectionForLazyListeners() {
        MessageBusConnection messageBusConnection = this.connect();
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return messageBusConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        this.checkNotDisposed();
        Object v = this.myPublishers.get(topic);
        if (v != null) {
            Object v2 = v;
            if (v2 != null) return (L)v2;
            MessageBusImpl.$$$reportNull$$$0(11);
            return (L)v2;
        }
        Class<L> listenerClass = topic.getListenerClass();
        if (this.myTopicClassToListenerClass == null) {
            Object newInstance = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
            Object prev = this.myPublishers.putIfAbsent(topic, newInstance);
            Object object = prev == null ? newInstance : prev;
            if (object != null) return (L)object;
            MessageBusImpl.$$$reportNull$$$0(12);
            return (L)object;
        }
        Topic<L> topic2 = topic;
        // MONITORENTER : topic2
        Object v3 = this.myPublishers.get(topic);
        if (v3 != null) {
            Object v4 = v3;
            // MONITOREXIT : topic2
            if (v4 != null) return (L)v4;
            MessageBusImpl.$$$reportNull$$$0(13);
            return (L)v4;
        }
        List listenerDescriptors = (List)this.myTopicClassToListenerClass.remove(listenerClass.getName());
        if (listenerDescriptors != null) {
            MessageBusConnection connection = this.createConnectionForLazyListeners();
            for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
                ClassLoader classLoader = listenerDescriptor.pluginDescriptor.getPluginClassLoader();
                try {
                    Object listener2 = ReflectionUtil.newInstance(Class.forName(listenerDescriptor.listenerClassName, true, classLoader), (boolean)false);
                    connection.subscribe(topic, listener2);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
        this.myPublishers.put(topic, object);
        Object object2 = object;
        // MONITOREXIT : topic2
        if (object2 != null) return (L)object2;
        MessageBusImpl.$$$reportNull$$$0(14);
        return (L)object2;
    }

    @NotNull
    private <L> InvocationHandler createTopicHandler(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod((Object)proxy, (Object[])args, (String)method.getName());
            }
            this.sendMessage(new Message(topic, method, args));
            return NA;
        };
        if (invocationHandler == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        return invocationHandler;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose((Disposable)childBus);
        }
        Disposer.dispose((Disposable)this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.myRootBus.myWaitingBuses.remove();
        }
        this.myRootBus = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        if (this.myDisposed) {
            return false;
        }
        if (!this.isDispatchingAnything()) {
            return false;
        }
        for (MessageBusConnectionImpl connection : this.getTopicSubscribers(topic)) {
            if (!connection.containsMessage(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isDispatchingAnything() {
        SortedMap waitingBuses = (SortedMap)this.myRootBus.myWaitingBuses.get();
        return waitingBuses != null && !waitingBuses.isEmpty();
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(@NotNull Topic topic, @NotNull List<? super MessageBusConnectionImpl> result) {
        Topic.BroadcastDirection direction;
        List topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        if (result == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        if ((topicSubscribers = (List)this.mySubscribers.get(topic)) != null) {
            result.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result);
        }
    }

    private void postMessage(@NotNull Message message) {
        if (message == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(@NotNull Topic topic) {
        List topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        if ((topicSubscribers = (List)this.mySubscriberCache.get(topic)) == null) {
            topicSubscribers = new SmartList();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
            if (this.myRootBus.myClearedSubscribersCache) {
                this.myRootBus.myClearedSubscribersCache = false;
            }
        }
        List list = topicSubscribers;
        if (list == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.myRootBus.myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map == null) {
            map = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map);
        }
        if ((newCount = (count = (countObject = (Integer)map.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map.put(this, newCount);
        } else if (newCount == 0) {
            map.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(@NotNull Message message) {
        if (message == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Map map = (Map)this.myRootBus.myWaitingBuses.get();
            if (map != null && !map.isEmpty()) {
                List liveBuses = null;
                for (MessageBusImpl bus : map.keySet()) {
                    if (!MessageBusImpl.ensureAlive(map, bus)) continue;
                    if (liveBuses == null) {
                        liveBuses = new SmartList();
                    }
                    liveBuses.add(bus);
                }
                if (liveBuses != null) {
                    MessageBusImpl.pumpWaitingBuses(liveBuses);
                }
            }
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(@Nullable List<Throwable> exceptions, @NotNull List<? extends Throwable> busExceptions) {
        if (busExceptions == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(@Nullable List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = (ProcessCanceledException)((Object)ContainerUtil.findInstance(exceptions, ProcessCanceledException.class));
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(@NotNull Map<MessageBusImpl, Integer> map, @NotNull MessageBusImpl bus) {
        if (map == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        if (bus.myDisposed) {
            map.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    @NotNull
    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        List exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e);
            }
        }
        List<Throwable> list = exceptions == null ? Collections.emptyList() : exceptions;
        if (list == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = (List)ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, (Object)topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.myRootBus.clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.myRootBus.clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal<Queue<T>> threadLocal = ThreadLocal.withInitial(ArrayDeque::new);
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        return threadLocal;
    }

    @ApiStatus.Internal
    public void setMessageDeliveryListener(@NotNull MessageDeliveryListener listener2) {
        if (listener2 == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        if (this.myListener != null) {
            throw new IllegalStateException("Already set: " + this.myListener);
        }
        this.myListener = listener2;
    }

    void notifyMessageDeliveryListener(@NotNull Topic topic, @NotNull String messageName, @NotNull Object handler, long durationNanos) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        if (messageName == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(36);
        }
        if (this.myListener != null) {
            this.myListener.messageDelivered(topic, messageName, handler, durationNanos);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busExceptions";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionForLazyListeners";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopicHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doPumpMessages";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTopicHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcSubscribers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "postMessage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTopicSubscribers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sendMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendExceptions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureAlive";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setMessageDeliveryListener";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notifyMessageDeliveryListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;
        private final MessageBusConnection myLazyConnection;
        volatile boolean myClearedSubscribersCache;

        @Override
        @NotNull
        protected MessageBusConnection createConnectionForLazyListeners() {
            MessageBusConnection messageBusConnection = this.myLazyConnection;
            if (messageBusConnection == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            return messageBusConnection;
        }

        @Override
        void clearSubscriberCache() {
            if (this.myClearedSubscribersCache) {
                return;
            }
            super.clearSubscriberCache();
            this.myClearedSubscribersCache = true;
        }

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(1);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
            this.myLazyConnection = this.connect();
            this.myRootBus = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl$RootBus";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConnectionForLazyListeners";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl$RootBus";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(@NotNull MessageBusConnectionImpl connection, @NotNull Message message) {
            if (connection == null) {
                DeliveryJob.$$$reportNull$$$0(0);
            }
            if (message == null) {
                DeliveryJob.$$$reportNull$$$0(1);
            }
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/messages/impl/MessageBusImpl$DeliveryJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

