/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalSearchScopes
extends GlobalSearchScopesCore {
    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        FileEditorManager fileEditorManager;
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(0);
        }
        VirtualFile[] files = (fileEditorManager = FileEditorManager.getInstance(project)) != null ? fileEditorManager.getOpenFiles() : VirtualFile.EMPTY_ARRAY;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, Arrays.asList(files), IdeBundle.message("scope.open.files", new Object[0]));
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope executionScope(@NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope;
        if (project == null) {
            GlobalSearchScopes.$$$reportNull$$$0(2);
        }
        if (runProfile instanceof SearchScopeProvidingRunProfile && (scope = ((SearchScopeProvidingRunProfile)runProfile).getSearchScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScopes.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScopes.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Nullable
    public static GlobalSearchScope executionScope(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            GlobalSearchScopes.$$$reportNull$$$0(5);
        }
        if (modules.isEmpty()) {
            return null;
        }
        List scopes = ContainerUtil.map2List(modules, module -> GlobalSearchScope.moduleRuntimeScope(module, true));
        return GlobalSearchScope.union(scopes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "openFilesScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFilesScope";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executionScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

