/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class RiverMaker {
    private static final int BASE_WIDTH = 128;
    private static final int BASE_HEIGHT = 64;
    private static final int HALF_WIDTH = 64;
    private static final int HALF_HEIGHT = 32;
    private static final float EDGE_LENGTH = (float)Math.sqrt(5120.0);
    private static final int DY = 4;
    private static final int DX = 8;
    private static final Point2D.Float NE = new Point2D.Float(72.0f, 4.0f);
    private static final Point2D.Float SE = new Point2D.Float(120.0f, 36.0f);
    private static final Point2D.Float SW = new Point2D.Float(8.0f, 36.0f);
    private static final Point2D.Float NW = new Point2D.Float(56.0f, 4.0f);
    private static final Point2D.Float CENTER = new Point2D.Float(64.0f, 8.0f);
    private static final Point2D.Float[] POINTS = new Point2D.Float[]{NE, SE, SW, NW};

    public static void main(String[] args) throws Exception {
        String riverName = "data/rules/classic/resources/images/terrain/ocean/center0.png";
        String riverDir = "data/rules/classic/resources/images/river";
        BufferedImage river = ImageIO.read(new File(riverName));
        river = river.getSubimage(44, 22, 40, 20);
        Rectangle rectangle = new Rectangle(0, 0, river.getWidth(), river.getHeight());
        TexturePaint texture = new TexturePaint(river, rectangle);
        BasicStroke minor = new BasicStroke(4.0f);
        BasicStroke major = new BasicStroke(6.0f);
        int[] branches = new int[]{1, 0, 0, 0};
        for (int index = 1; index < 81; ++index) {
            BufferedImage result = new BufferedImage(128, 64, 2);
            Graphics2D g = result.createGraphics();
            g.setPaint(texture);
            String name = RiverMaker.getName(branches);
            int count = RiverMaker.branchCount(branches);
            for (int branch = 0; branch < branches.length; ++branch) {
                int size = branches[branch];
                if (size <= 0) continue;
                g.setStroke(size == 1 ? minor : major);
                int next = (branch + 1) % 4;
                int other = (branch + 2) % 4;
                Path2D.Float bend = new Path2D.Float();
                float px = (RiverMaker.POINTS[branch].x + RiverMaker.POINTS[other].x) / 2.0f;
                float py = (RiverMaker.POINTS[branch].y + RiverMaker.POINTS[other].y) / 2.0f;
                bend.moveTo(RiverMaker.POINTS[branch].x, RiverMaker.POINTS[branch].y);
                if (count == 1) {
                    bend.lineTo(px, py);
                    g.draw(bend);
                    break;
                }
                if (branches[other] > 0) {
                    bend.lineTo(px, py);
                    bend.moveTo(RiverMaker.POINTS[branch].x, RiverMaker.POINTS[branch].y);
                }
                if (branches[next] > 0) {
                    bend.quadTo(RiverMaker.CENTER.x, RiverMaker.CENTER.y, (RiverMaker.POINTS[next].x + RiverMaker.CENTER.x) / 2.0f, (RiverMaker.POINTS[next].y + RiverMaker.CENTER.y) / 2.0f);
                    bend.lineTo(RiverMaker.POINTS[next].x, RiverMaker.POINTS[next].y);
                }
                g.draw(bend);
            }
            g.dispose();
            ImageIO.write((RenderedImage)result, "png", new File(riverDir, "river" + name + ".png"));
            branches = RiverMaker.nextBranch(branches);
        }
    }

    private static int[] nextBranch(int[] branches) {
        for (int index = 0; index < branches.length; ++index) {
            if (branches[index] != 2) {
                int n = index;
                branches[n] = branches[n] + 1;
                break;
            }
            branches[index] = 0;
        }
        return branches;
    }

    private static int branchCount(int[] branches) {
        int result = 0;
        for (int branche : branches) {
            if (branche <= 0) continue;
            ++result;
        }
        return result;
    }

    private static String getName(int[] branches) {
        String name = "";
        for (int branche : branches) {
            name = name + Integer.toString(branche);
        }
        return name;
    }
}

