/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openide.awt.HtmlLabelUI;
import org.openide.awt.HtmlRendererImpl;
import org.openide.util.Utilities;

public final class HtmlRenderer {
    private static Stack<Color> colorStack = new Stack();
    public static final int STYLE_CLIP = 0;
    public static final int STYLE_TRUNCATE = 1;
    private static final int STYLE_WORDWRAP = 2;
    private static final boolean STRICT_HTML = Boolean.getBoolean("netbeans.lwhtml.strict");
    private static Set<String> badStrings = null;
    private static Logger LOG = Logger.getLogger(HtmlRenderer.class.getName());
    private static final Object[] entities = new Object[]{new char[]{'g', 't'}, new char[]{'l', 't'}, new char[]{'q', 'u', 'o', 't'}, new char[]{'a', 'm', 'p'}, new char[]{'l', 's', 'q', 'u', 'o'}, new char[]{'r', 's', 'q', 'u', 'o'}, new char[]{'l', 'd', 'q', 'u', 'o'}, new char[]{'r', 'd', 'q', 'u', 'o'}, new char[]{'n', 'd', 'a', 's', 'h'}, new char[]{'m', 'd', 'a', 's', 'h'}, new char[]{'n', 'e'}, new char[]{'l', 'e'}, new char[]{'g', 'e'}, new char[]{'c', 'o', 'p', 'y'}, new char[]{'r', 'e', 'g'}, new char[]{'t', 'r', 'a', 'd', 'e'}, new char[]{'n', 'b', 's', 'p'}};
    private static final char[] entitySubstitutions = new char[]{'>', '<', '\"', '&', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u2260', '\u2264', '\u2265', '\u00a9', '\u00ae', '\u2122', ' '};

    private HtmlRenderer() {
    }

    public static final Renderer createRenderer() {
        return new HtmlRendererImpl();
    }

    public static final JLabel createLabel() {
        return new HtmlRendererImpl();
    }

    public static double renderPlainString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        if (n5 < 0 || n5 > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + n5);
        }
        return HtmlRenderer._renderPlainString(string, graphics, n, n2, n3, n4, font, color, n5, bl);
    }

    private static double _renderPlainString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        if (font == null && (font = UIManager.getFont("controlFont")) == null) {
            int n6 = 11;
            Object object = UIManager.get("customFontSize");
            if (object instanceof Integer) {
                n6 = (Integer)object;
            }
            font = new Font("Dialog", 0, n6);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n7 = Utilities.isMac() ? fontMetrics.stringWidth(string) : (int)fontMetrics.getStringBounds(string, graphics).getWidth();
        if (bl) {
            graphics.setColor(color);
            graphics.setFont(font);
            if (n7 <= n3 || n5 == 0) {
                graphics.drawString(string, n, n2);
            } else {
                int n8;
                char[] cArray = string.toCharArray();
                if (cArray.length == 0) {
                    return 0.0;
                }
                double d = n7 / cArray.length;
                int n9 = new Double((double)n3 / d).intValue();
                if (n9 > cArray.length) {
                    n9 = cArray.length;
                }
                while (n9 > 3) {
                    if (n9 < cArray.length) {
                        cArray[n9 - 1] = 8230;
                    }
                    if ((n8 = Utilities.isMac() ? fontMetrics.stringWidth(new String(cArray, 0, n9)) : (int)fontMetrics.getStringBounds(cArray, 0, n9, graphics).getWidth()) <= n3) break;
                    --n9;
                }
                if (n5 == 1) {
                    n8 = n9;
                    if (n8 <= 0) {
                        return 0.0;
                    }
                    if (bl) {
                        if (n8 > 3) {
                            graphics.drawChars(cArray, 0, n8, n, n2);
                        } else {
                            Shape shape = graphics.getClip();
                            if (shape != null) {
                                if (string != null) {
                                    Area area = new Area(shape);
                                    area.intersect(new Area(new Rectangle(n, n2, n3, n4)));
                                    graphics.setClip(area);
                                } else {
                                    graphics.setClip(new Rectangle(n, n2, n3, n4));
                                }
                            }
                            graphics.drawString("\u2026", n, n2);
                            if (shape != null) {
                                graphics.setClip(shape);
                            }
                        }
                    }
                }
            }
        }
        return n7;
    }

    public static double renderString(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        switch (n5) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rendering mode: " + n5);
            }
        }
        if (string.startsWith("<html") || string.startsWith("<HTML")) {
            return HtmlRenderer._renderHTML(string, 6, graphics, n, n2, n3, n4, font, color, n5, bl, null);
        }
        return HtmlRenderer.renderPlainString(string, graphics, n, n2, n3, n4, font, color, n5, bl);
    }

    public static double renderHTML(String string, Graphics graphics, int n, int n2, int n3, int n4, Font font, Color color, int n5, boolean bl) {
        if (n5 < 0 || n5 > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + n5);
        }
        return HtmlRenderer._renderHTML(string, 0, graphics, n, n2, n3, n4, font, color, n5, bl, null);
    }

    static double _renderHTML(String string, int n, Graphics graphics, int n2, int n3, int n4, int n5, Font font, Color color, int n6, boolean bl, Color color2) {
        return HtmlRenderer._renderHTML(string, n, graphics, n2, n3, n4, n5, font, color, n6, bl, color2, false);
    }

    static double _renderHTML(String string, int n, Graphics graphics, int n2, int n3, int n4, int n5, Font font, Color color, int n6, boolean bl, Color color2, boolean bl2) {
        Object object;
        if (font == null && (font = UIManager.getFont("controlFont")) == null) {
            int n7 = 11;
            object = UIManager.get("customFontSize");
            if (object instanceof Integer) {
                n7 = (Integer)object;
            }
            font = new Font("Dialog", 0, n7);
        }
        Stack<Color> stack = SwingUtilities.isEventDispatchThread() ? colorStack : new Stack<Color>();
        graphics.setColor(color);
        graphics.setFont(font);
        if (HtmlLabelUI.antialias && graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        object = string.toCharArray();
        int n8 = n2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl12 = false;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl13 = false;
        if (n6 == 1) {
            d4 = graphics.getFontMetrics().charWidth('.');
        }
        stack.clear();
        while (!bl3) {
            double d5;
            int n9;
            int n10;
            block101: {
                block103: {
                    block102: {
                        boolean bl14;
                        if (n == string.length()) {
                            if (bl11 && bl && !bl13) {
                                graphics.setColor(color);
                                graphics.setFont(font);
                                graphics.drawString("\u2026", n2, n3);
                            }
                            return d;
                        }
                        try {
                            bl14 = object[n] == 60;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = new ArrayIndexOutOfBoundsException("HTML rendering failed at position " + n + " in String \"" + string + "\".  Please report this at http://www.netbeans.org");
                            if (STRICT_HTML) {
                                throw arrayIndexOutOfBoundsException2;
                            }
                            Logger.getLogger(HtmlRenderer.class.getName()).log(Level.WARNING, null, arrayIndexOutOfBoundsException2);
                            return HtmlRenderer.renderPlainString(string, graphics, n2, n3, n4, n5, font, color, n6, bl);
                        }
                        boolean bl15 = bl5 = (bl4 |= bl14) && n + 1 < ((Object)object).length && object[n + 1] == 47;
                        if (bl11) {
                            graphics.setColor(color);
                            graphics.setFont(font);
                            if (bl) {
                                graphics.drawString("\u2026", n2, n3);
                                bl13 = true;
                            }
                            bl3 = true;
                            continue;
                        }
                        if (!bl4) break block101;
                        boolean bl16 = bl3 = (n10 = ++n) >= ((Object)object).length - 1;
                        while (!bl3 && object[n10] != 62) {
                            bl3 = n10 == ((Object)object).length - 1;
                            ++n10;
                        }
                        if (bl3) {
                            HtmlRenderer.throwBadHTML("Matching '>' not found", n, (char[])object);
                            break;
                        }
                        if (!bl5) break block102;
                        block1 : switch (object[++n]) {
                            case 65: 
                            case 97: {
                                if (stack.isEmpty() || bl2) {
                                    graphics.setColor(color);
                                } else {
                                    graphics.setColor((Color)stack.pop());
                                }
                                bl8 = false;
                                break;
                            }
                            case 72: 
                            case 80: 
                            case 104: 
                            case 112: {
                                break;
                            }
                            case 66: 
                            case 98: {
                                if (object[n + 1] != 114) {
                                    if (object[n + 1] == 82) break;
                                    if (!bl9 && object[n + 1] != 111 && object[n + 1] != 79) {
                                        HtmlRenderer.throwBadHTML("Closing bold tag w/o opening bold tag", n, (char[])object);
                                    }
                                    if (bl10) {
                                        graphics.setFont(HtmlRenderer.deriveFont(font, 2));
                                    } else {
                                        graphics.setFont(HtmlRenderer.deriveFont(font, 0));
                                    }
                                    bl9 = false;
                                    break;
                                }
                                break block103;
                            }
                            case 69: 
                            case 73: 
                            case 101: 
                            case 105: {
                                if (bl9) {
                                    graphics.setFont(HtmlRenderer.deriveFont(font, 1));
                                } else {
                                    graphics.setFont(HtmlRenderer.deriveFont(font, 0));
                                }
                                if (!bl10) {
                                    HtmlRenderer.throwBadHTML("Closing italics tag w/oopening italics tag", n, (char[])object);
                                }
                                bl10 = false;
                                break;
                            }
                            case 83: 
                            case 115: {
                                switch (object[n + 1]) {
                                    case 84: 
                                    case 116: {
                                        if (bl10) {
                                            graphics.setFont(HtmlRenderer.deriveFont(font, 2));
                                        } else {
                                            graphics.setFont(HtmlRenderer.deriveFont(font, 0));
                                        }
                                        bl9 = false;
                                        break block1;
                                    }
                                    case 62: {
                                        bl6 = false;
                                    }
                                }
                                break;
                            }
                            case 85: 
                            case 117: {
                                bl7 = false;
                                break;
                            }
                            case 70: 
                            case 102: {
                                if (stack.isEmpty() || bl2) {
                                    graphics.setColor(color);
                                    break;
                                }
                                graphics.setColor((Color)stack.pop());
                                break;
                            }
                            default: {
                                HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", n, (char[])object);
                                break;
                            }
                        }
                        break block103;
                    }
                    switch (object[n]) {
                        case 65: 
                        case 97: {
                            if (!bl2) {
                                Color color3 = UIManager.getColor("nb.html.link.foreground");
                                if (color3 == null) {
                                    color3 = Color.BLUE;
                                }
                                stack.push(graphics.getColor());
                                color3 = HtmlLabelUI.ensureContrastingColor(color3, color2);
                                graphics.setColor(color3);
                            }
                            bl8 = true;
                            break;
                        }
                        case 66: 
                        case 98: {
                            switch (object[n + 1]) {
                                case 82: 
                                case 114: {
                                    if (n6 != 2) break;
                                    n2 = n8;
                                    int n11 = graphics.getFontMetrics().getHeight();
                                    n3 += n11;
                                    d2 += (double)n11;
                                    d = 0.0;
                                    break;
                                }
                                case 62: {
                                    bl9 = true;
                                    if (bl10) {
                                        graphics.setFont(HtmlRenderer.deriveFont(font, 3));
                                        break;
                                    }
                                    graphics.setFont(HtmlRenderer.deriveFont(font, 1));
                                }
                            }
                            break;
                        }
                        case 69: 
                        case 73: 
                        case 101: 
                        case 105: {
                            bl10 = true;
                            if (bl9) {
                                graphics.setFont(HtmlRenderer.deriveFont(font, 3));
                                break;
                            }
                            graphics.setFont(HtmlRenderer.deriveFont(font, 2));
                            break;
                        }
                        case 83: 
                        case 115: {
                            switch (object[n + 1]) {
                                case 62: {
                                    bl6 = true;
                                    break;
                                }
                                case 84: 
                                case 116: {
                                    bl9 = true;
                                    if (bl10) {
                                        graphics.setFont(HtmlRenderer.deriveFont(font, 3));
                                        break;
                                    }
                                    graphics.setFont(HtmlRenderer.deriveFont(font, 1));
                                }
                            }
                            break;
                        }
                        case 85: 
                        case 117: {
                            bl7 = true;
                            break;
                        }
                        case 70: 
                        case 102: {
                            if (bl2) break;
                            Color color4 = HtmlRenderer.findColor((char[])object, n, n10);
                            stack.push(graphics.getColor());
                            color4 = HtmlLabelUI.ensureContrastingColor(color4, color2);
                            graphics.setColor(color4);
                            break;
                        }
                        case 80: 
                        case 112: {
                            if (n6 != 2) break;
                            n2 = n8;
                            int n12 = graphics.getFontMetrics().getHeight();
                            d2 = (n3 += n12 + n12 / 2) + n12;
                            d = 0.0;
                            break;
                        }
                        case 72: 
                        case 104: {
                            if (n == 1) break;
                            HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", n, (char[])object);
                            break;
                        }
                        default: {
                            HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", n, (char[])object);
                        }
                    }
                }
                n = n10 + (bl3 ? 0 : 1);
                bl4 = false;
                continue;
            }
            if (bl12) {
                while (n < string.length() - 1 && Character.isWhitespace((char)object[n])) {
                    ++n;
                }
                if (n == ((Object)object).length - 1) {
                    return n6 != 2 ? d : d2;
                }
            }
            n10 = 0;
            boolean bl17 = false;
            int n13 = ((Object)object).length - 1;
            if (object[n] == 38) {
                int n14 = n9 = n != ((Object)object).length - 1 ? 1 : 0;
                if (n9 != 0) {
                    int n15 = HtmlRenderer.substEntity((char[])object, n + 1);
                    int n16 = n9 = n15 != -1 ? 1 : 0;
                    if (n9 != 0) {
                        n = n15;
                        n10 = object[n] == 38 ? 1 : 0;
                        bl17 = object[n] == 60;
                    } else {
                        bl17 = false;
                        n10 = 1;
                    }
                }
            } else {
                bl17 = false;
            }
            for (n9 = n; n9 < ((Object)object).length; ++n9) {
                if (object[n9] == 60 && !bl17 || object[n9] == 38 && n10 == 0 && n9 != ((Object)object).length - 1) {
                    n13 = n9 - 1;
                    break;
                }
                n10 = 0;
                bl17 = false;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds((char[])object, n, n13 + 1, graphics);
            if (Utilities.isMac()) {
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), fontMetrics.stringWidth(new String((char[])object, n, n13 - n + 1)), rectangle2D.getHeight());
            }
            d3 = rectangle2D.getHeight();
            int n17 = n13 + 1 - n;
            boolean bl18 = false;
            boolean bl19 = false;
            if (bl11) {
                d5 = d4;
            } else {
                d5 = rectangle2D.getWidth() / (double)(n13 + 1 - n);
                if (d5 == Double.POSITIVE_INFINITY || d5 == Double.NEGATIVE_INFINITY) {
                    d5 = fontMetrics.getMaxAdvance();
                }
            }
            if ((n6 != 0 && n6 == 1 && d + rectangle2D.getWidth() > (double)n4 || n6 == 2 && d + rectangle2D.getWidth() > (double)n4) && d5 > 3.0) {
                int n18;
                int n19;
                double d6 = d + (rectangle2D.getWidth() + 5.0) - (double)n4;
                double d7 = d6 / d5;
                if (n6 == 1) {
                    n19 = Math.round(Math.round(Math.ceil(((double)n4 - d) / d5)));
                    n18 = n + n19 - 3;
                    if (n18 >= ((Object)object).length) {
                        n18 = ((Object)object).length - 4;
                    }
                    if ((n17 = n18 - n) < 0) {
                        n17 = 0;
                    }
                    rectangle2D = fontMetrics.getStringBounds((char[])object, n, n + n17, graphics);
                    if (Utilities.isMac()) {
                        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), fontMetrics.stringWidth(new String((char[])object, n, n17)), rectangle2D.getHeight());
                    }
                    bl11 = true;
                } else {
                    bl18 = true;
                    n19 = new Double((double)n13 - d7).intValue();
                    bl19 = n2 == 0;
                    for (n18 = n19; n18 > n; --n18) {
                        --n19;
                        if (!Character.isWhitespace((char)object[n18])) continue;
                        n17 = n19 - n + 1;
                        bl19 = false;
                        break;
                    }
                    if (n19 <= n && (double)n17 > d7 && !bl19) {
                        n2 = n8;
                        n3 = (int)((double)n3 + rectangle2D.getHeight());
                        d2 += rectangle2D.getHeight();
                        n18 = 0;
                        while (!bl3 && Character.isWhitespace((char)object[n]) && n < n13) {
                            n18 = 1;
                            bl3 = ++n == ((Object)object).length - 1;
                        }
                        if (n == n13) {
                            bl12 = true;
                        }
                        if (n18 != 0) {
                            rectangle2D = fontMetrics.getStringBounds((char[])object, n, n13 + 1, graphics);
                            if (Utilities.isMac()) {
                                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), fontMetrics.stringWidth(new String((char[])object, n, n13 - n + 1)), rectangle2D.getHeight());
                            }
                        }
                        bl18 = false;
                        d = 0.0;
                        if (object[n - 1 + n17] == 60) {
                            --n17;
                        }
                    } else if (bl19) {
                        n17 = new Double(((double)n4 - d) / d5).intValue();
                        if (n + n17 > n13) {
                            n17 = n13 - n;
                        }
                        bl18 = true;
                    }
                }
            }
            if (bl3) continue;
            if (bl) {
                graphics.drawChars((char[])object, n, n17, n2, n3);
            }
            if (bl6 || bl7 || bl8) {
                LineMetrics lineMetrics = fontMetrics.getLineMetrics((char[])object, n, n17 - 1, graphics);
                int n20 = new Double((double)n2 + rectangle2D.getWidth()).intValue();
                if (bl) {
                    if (bl6) {
                        int n21 = Math.round(lineMetrics.getStrikethroughOffset()) + graphics.getFont().getBaselineFor((char)object[n]) + 1;
                        graphics.drawLine(n2, n3 + n21, n20, n3 + n21);
                    }
                    if (bl7 || bl8) {
                        int n22 = Math.round(lineMetrics.getUnderlineOffset()) + graphics.getFont().getBaselineFor((char)object[n]) + 1;
                        graphics.drawLine(n2, n3 + n22, n20, n3 + n22);
                    }
                }
            }
            if (bl18) {
                n2 = n8;
                n3 = (int)((double)n3 + rectangle2D.getHeight());
                d2 += rectangle2D.getHeight();
                d = 0.0;
                n += n17;
                while (n < ((Object)object).length && Character.isWhitespace((char)object[n]) && object[n] != 60) {
                    ++n;
                }
                bl12 = true;
                bl3 |= n >= ((Object)object).length;
            } else {
                n2 = (int)((double)n2 + rectangle2D.getWidth());
                d += rectangle2D.getWidth();
                bl12 = Character.isWhitespace((char)object[n13]);
                n = n13 + 1;
            }
            bl3 |= n13 == ((Object)object).length;
        }
        if (n6 != 2) {
            return d;
        }
        return d2 + d3;
    }

    private static Color findColor(char[] cArray, int n, int n2) {
        String string;
        int n3;
        int n4 = n;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != 'c') continue;
            if (i + 6 >= cArray.length) break;
            n4 = i + 6;
            if (cArray[n4] == '\'' || cArray[n4] == '\"') {
                ++n4;
            }
            if (cArray[n4] == '#') {
                ++n4;
                break;
            }
            if (cArray[n4] != '!') break;
            bl = true;
            ++n4;
            break;
        }
        if (n4 == n) {
            String string2 = "Could not find color identifier in font declaration";
            HtmlRenderer.throwBadHTML(string2, n, cArray);
        }
        if (bl) {
            int n5 = cArray.length - 1;
            for (n3 = n4; n3 < cArray.length; ++n3) {
                if (cArray[n3] != '\"' && cArray[n3] != '\'') continue;
                n5 = n3;
                break;
            }
            string = new String(cArray, n4, n5 - n4);
        } else {
            string = new String(cArray, n4, Math.min(cArray.length - n4, 6));
        }
        Color color = null;
        if (bl) {
            color = UIManager.getColor(string);
            if (color == null) {
                HtmlRenderer.throwBadHTML("Could not resolve logical font declared in HTML: " + string, n, cArray);
                color = UIManager.getColor("textText");
                if (color == null) {
                    color = Color.BLACK;
                }
            }
        } else {
            try {
                n3 = Integer.parseInt(string, 16);
                color = new Color(n3);
            }
            catch (NumberFormatException numberFormatException) {
                HtmlRenderer.throwBadHTML("Illegal hexadecimal color text: " + string + " in HTML string", n4, cArray);
            }
        }
        if (color == null) {
            HtmlRenderer.throwBadHTML("Unresolvable html color: " + string + " in HTML string \n  ", n, cArray);
        }
        return color;
    }

    private static final Font deriveFont(Font font, int n) {
        Font font2 = Utilities.isMac() ? new Font(font.getName(), n, font.getSize()) : font.deriveFont(n);
        return font2;
    }

    private static final int substEntity(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            return -1;
        }
        if (cArray[n] == '#') {
            return HtmlRenderer.substNumericEntity(cArray, n + 1);
        }
        for (int i = 0; i < entities.length; ++i) {
            char[] cArray2 = (char[])entities[i];
            boolean bl = true;
            if (cArray2.length < cArray.length - n) {
                for (int j = 0; j < cArray2.length; ++j) {
                    bl &= cArray2[j] == cArray[j + n];
                }
            } else {
                bl = false;
            }
            if (!bl || cArray[n + cArray2.length] != ';') continue;
            cArray[n + cArray2.length] = entitySubstitutions[i];
            return n + cArray2.length;
        }
        return -1;
    }

    private static final int substNumericEntity(char[] cArray, int n) {
        for (int i = n; i < cArray.length; ++i) {
            if (cArray[i] != ';') continue;
            try {
                cArray[i] = (char)Integer.parseInt(new String(cArray, n, i - n));
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                HtmlRenderer.throwBadHTML("Unparsable numeric entity: " + new String(cArray, n, i - n), n, cArray);
            }
        }
        return -1;
    }

    private static void throwBadHTML(String string, int n, char[] cArray) {
        char[] cArray2 = new char[n];
        Arrays.fill(cArray2, ' ');
        cArray2[n - 1] = 94;
        String string2 = string + "\n  " + new String(cArray) + "\n  " + new String(cArray2) + "\n Full HTML string:" + new String(cArray);
        if (!STRICT_HTML) {
            if (LOG.isLoggable(Level.WARNING)) {
                if (badStrings == null) {
                    badStrings = new HashSet<String>();
                }
                if (!badStrings.contains(string)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        LOG.warning(stringTokenizer.nextToken());
                    }
                    badStrings.add(string.intern());
                }
            }
        } else {
            throw new IllegalArgumentException(string2);
        }
    }

    public static interface Renderer
    extends TableCellRenderer,
    TreeCellRenderer,
    ListCellRenderer {
        public void setParentFocused(boolean var1);

        public void setCentered(boolean var1);

        public void setIndent(int var1);

        public void setHtml(boolean var1);

        public void setRenderStyle(int var1);

        public void setIcon(Icon var1);

        public void reset();

        public void setText(String var1);

        public void setIconTextGap(int var1);
    }
}

